/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import jakarta.servlet.http.Cookie;
import java.io.Serializable;

public class SavedCookie
implements Serializable {
    private static final long serialVersionUID = 620L;
    private final String name;
    private final String value;
    private final String domain;
    private final int maxAge;
    private final String path;
    private final boolean secure;

    public SavedCookie(String name, String value, String domain, int maxAge, String path, boolean secure) {
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.maxAge = maxAge;
        this.path = path;
        this.secure = secure;
    }

    public SavedCookie(Cookie cookie) {
        this(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getMaxAge(), cookie.getPath(), cookie.getSecure());
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Cookie getCookie() {
        Cookie cookie = new Cookie(this.getName(), this.getValue());
        if (this.getDomain() != null) {
            cookie.setDomain(this.getDomain());
        }
        if (this.getPath() != null) {
            cookie.setPath(this.getPath());
        }
        cookie.setMaxAge(this.getMaxAge());
        cookie.setSecure(this.isSecure());
        return cookie;
    }
}

