/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DelegatingAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final Flux<DelegateEntry> entryPoints;
    private AuthenticationEntryPoint defaultEntryPoint = (exchange, e) -> {
        exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
        return exchange.getResponse().setComplete();
    };

    public DelegatingAuthenticationEntryPoint(DelegateEntry ... entryPoints) {
        this(Arrays.asList(entryPoints));
    }

    public DelegatingAuthenticationEntryPoint(List<DelegateEntry> entryPoints) {
        this.entryPoints = Flux.fromIterable(entryPoints);
    }

    @Override
    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException e) {
        return this.entryPoints.filterWhen(entry -> this.isMatch(exchange, (DelegateEntry)entry)).next().map(entry -> entry.getEntryPoint()).defaultIfEmpty((Object)this.defaultEntryPoint).flatMap(entryPoint -> entryPoint.commence(exchange, e));
    }

    private Mono<Boolean> isMatch(ServerWebExchange exchange, DelegateEntry entry) {
        ServerWebExchangeMatcher matcher = entry.getMatcher();
        return matcher.matches(exchange).map(result -> result.isMatch());
    }

    public void setDefaultEntryPoint(AuthenticationEntryPoint defaultEntryPoint) {
        this.defaultEntryPoint = defaultEntryPoint;
    }

    public static class DelegateEntry {
        private final ServerWebExchangeMatcher matcher;
        private final AuthenticationEntryPoint entryPoint;

        public DelegateEntry(ServerWebExchangeMatcher matcher, AuthenticationEntryPoint entryPoint) {
            this.matcher = matcher;
            this.entryPoint = entryPoint;
        }

        public ServerWebExchangeMatcher getMatcher() {
            return this.matcher;
        }

        public AuthenticationEntryPoint getEntryPoint() {
            return this.entryPoint;
        }
    }
}

