/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MatcherSecurityWebFilterChain
implements SecurityWebFilterChain {
    private final ServerWebExchangeMatcher matcher;
    private final Flux<WebFilter> filters;

    public MatcherSecurityWebFilterChain(ServerWebExchangeMatcher matcher, List<WebFilter> filters) {
        this(matcher, (Flux<WebFilter>)Flux.fromIterable(filters));
    }

    public MatcherSecurityWebFilterChain(ServerWebExchangeMatcher matcher, Flux<WebFilter> filters) {
        this.matcher = matcher;
        this.filters = filters;
    }

    @Override
    public Mono<Boolean> matches(ServerWebExchange exchange) {
        return this.matcher.matches(exchange).map(m -> m.isMatch());
    }

    @Override
    public Flux<WebFilter> getWebFilters() {
        return this.filters;
    }
}

