/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.MatcherSecurityWebFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import org.springframework.web.server.handler.FilteringWebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFilterChainFilter
implements WebFilter {
    private final Flux<SecurityWebFilterChain> filters;

    public WebFilterChainFilter(Flux<SecurityWebFilterChain> filters) {
        this.filters = filters;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.filters.filterWhen(securityWebFilterChain -> securityWebFilterChain.matches(exchange)).next().flatMap(securityWebFilterChain -> securityWebFilterChain.getWebFilters().collectList()).map(filters -> new FilteringWebHandler(webHandler -> chain.filter(webHandler), filters)).map(handler -> new DefaultWebFilterChain((WebHandler)handler, new WebFilter[0])).flatMap(securedChain -> securedChain.filter(exchange));
    }

    public static WebFilterChainFilter fromWebFiltersList(List<WebFilter> filters) {
        return new WebFilterChainFilter((Flux<SecurityWebFilterChain>)Flux.just((Object)new MatcherSecurityWebFilterChain(ServerWebExchangeMatchers.anyExchange(), filters)));
    }

    public static WebFilterChainFilter fromSecurityWebFilterChainsList(List<SecurityWebFilterChain> securityWebFilterChains) {
        return new WebFilterChainFilter((Flux<SecurityWebFilterChain>)Flux.fromIterable(securityWebFilterChains));
    }

    public static WebFilterChainFilter fromSecurityWebFilterChains(SecurityWebFilterChain ... securityWebFilterChains) {
        return WebFilterChainFilter.fromSecurityWebFilterChainsList(Arrays.asList(securityWebFilterChains));
    }
}

