/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.HttpBasicAuthenticationConverter;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.WebFilterChainAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.www.HttpBasicAuthenticationEntryPoint;
import org.springframework.security.web.server.context.SecurityContextRepository;
import org.springframework.security.web.server.context.SecurityContextRepositoryServerWebExchange;
import org.springframework.security.web.server.context.ServerWebExchangeAttributeSecurityContextRepository;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AuthenticationWebFilter
implements WebFilter {
    private final ReactiveAuthenticationManager authenticationManager;
    private AuthenticationSuccessHandler authenticationSuccessHandler = new WebFilterChainAuthenticationSuccessHandler();
    private Function<ServerWebExchange, Mono<Authentication>> authenticationConverter = new HttpBasicAuthenticationConverter();
    private AuthenticationFailureHandler authenticationFailureHandler = new AuthenticationEntryPointFailureHandler(new HttpBasicAuthenticationEntryPoint());
    private SecurityContextRepository securityContextRepository = new ServerWebExchangeAttributeSecurityContextRepository();
    private ServerWebExchangeMatcher requiresAuthenticationMatcher = ServerWebExchangeMatchers.anyExchange();

    public AuthenticationWebFilter(ReactiveAuthenticationManager authenticationManager) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        SecurityContextRepositoryServerWebExchange wrappedExchange = new SecurityContextRepositoryServerWebExchange(exchange, this.securityContextRepository);
        return this.filterInternal((ServerWebExchange)wrappedExchange, chain);
    }

    private Mono<Void> filterInternal(ServerWebExchange wrappedExchange, WebFilterChain chain) {
        return this.requiresAuthenticationMatcher.matches(wrappedExchange).filter(matchResult -> matchResult.isMatch()).flatMap(matchResult -> this.authenticationConverter.apply(wrappedExchange)).switchIfEmpty(chain.filter(wrappedExchange).then(Mono.empty())).flatMap(token -> this.authenticate(wrappedExchange, chain, (Authentication)token));
    }

    private Mono<Void> authenticate(ServerWebExchange wrappedExchange, WebFilterChain chain, Authentication token) {
        WebFilterExchange webFilterExchange = new WebFilterExchange(wrappedExchange, chain);
        return this.authenticationManager.authenticate(token).flatMap(authentication -> this.onAuthenticationSuccess((Authentication)authentication, webFilterExchange)).onErrorResume(AuthenticationException.class, e -> this.authenticationFailureHandler.onAuthenticationFailure(webFilterExchange, (AuthenticationException)e));
    }

    private Mono<Void> onAuthenticationSuccess(Authentication authentication, WebFilterExchange webFilterExchange) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication(authentication);
        return this.securityContextRepository.save(exchange, (SecurityContext)securityContext).then(this.authenticationSuccessHandler.success(authentication, webFilterExchange));
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationConverter(Function<ServerWebExchange, Mono<Authentication>> authenticationConverter) {
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setRequiresAuthenticationMatcher(ServerWebExchangeMatcher requiresAuthenticationMatcher) {
        Assert.notNull((Object)requiresAuthenticationMatcher, (String)"requiresAuthenticationMatcher cannot be null");
        this.requiresAuthenticationMatcher = requiresAuthenticationMatcher;
    }
}

