/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.net.URI;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.server.AuthenticationEntryPoint;
import org.springframework.security.web.server.DefaultRedirectStrategy;
import org.springframework.security.web.server.RedirectStrategy;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final URI location;
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public RedirectAuthenticationEntryPoint(String location) {
        Assert.notNull((Object)location, (String)"location cannot be null");
        this.location = URI.create(location);
    }

    @Override
    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException e) {
        return this.redirectStrategy.sendRedirect(exchange, this.location);
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        Assert.notNull((Object)redirectStrategy, (String)"redirectStrategy cannot be null");
        this.redirectStrategy = redirectStrategy;
    }
}

