/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.net.URI;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.DefaultRedirectStrategy;
import org.springframework.security.web.server.RedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.AuthenticationSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private URI location = URI.create("/");
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    public RedirectAuthenticationSuccessHandler() {
    }

    public RedirectAuthenticationSuccessHandler(String location) {
        this.location = URI.create(location);
    }

    @Override
    public Mono<Void> success(Authentication authentication, WebFilterExchange webFilterExchange) {
        ServerWebExchange exchange = webFilterExchange.getExchange();
        return this.redirectStrategy.sendRedirect(exchange, this.location);
    }

    public void setLocation(URI location) {
        Assert.notNull((Object)location, (String)"location cannot be null");
        this.location = location;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        Assert.notNull((Object)redirectStrategy, (String)"redirectStrategy cannot be null");
        this.redirectStrategy = redirectStrategy;
    }
}

