/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.header;

import java.util.Arrays;
import java.util.Collections;
import org.springframework.http.HttpHeaders;
import org.springframework.security.web.server.header.HttpHeadersWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class StaticHttpHeadersWriter
implements HttpHeadersWriter {
    private final HttpHeaders headersToAdd;

    public StaticHttpHeadersWriter(HttpHeaders headersToAdd) {
        this.headersToAdd = headersToAdd;
    }

    @Override
    public Mono<Void> writeHttpHeaders(ServerWebExchange exchange) {
        HttpHeaders headers = exchange.getResponse().getHeaders();
        boolean containsOneHeaderToAdd = Collections.disjoint(headers.keySet(), this.headersToAdd.keySet());
        if (containsOneHeaderToAdd) {
            this.headersToAdd.forEach((name, values) -> headers.put(name, values));
        }
        return Mono.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private HttpHeaders headers = new HttpHeaders();

        public Builder header(String headerName, String ... values) {
            this.headers.put(headerName, Arrays.asList(values));
            return this;
        }

        public StaticHttpHeadersWriter build() {
            return new StaticHttpHeadersWriter(this.headers);
        }
    }
}

