/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data.provider;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Set;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.serialization.data.AbstractDataSerializableSessionSerializer;

public class DataSerializableSessionAttributesSerializer
extends AbstractDataSerializableSessionSerializer<AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes> {
    public static void register() {
        DataSerializableSessionAttributesSerializer.register(DataSerializableSessionAttributesSerializer.class);
    }

    @Override
    public int getId() {
        return -2121093915;
    }

    @Override
    public Class<?>[] getSupportedClasses() {
        return (Class[])ArrayUtils.asArray((Object[])new Class[]{AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes.class, AbstractGemFireOperationsSessionRepository.DeltaCapableGemFireSessionAttributes.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes sessionAttributes, DataOutput out) {
        Object object = sessionAttributes.getLock();
        synchronized (object) {
            Set attributeNames = CollectionUtils.nullSafeSet(sessionAttributes.getAttributeNames());
            this.safeWrite(out, output -> output.writeInt(attributeNames.size()));
            attributeNames.forEach(attributeName -> {
                this.safeWrite(out, output -> output.writeUTF((String)attributeName));
                this.safeWrite(out, output -> this.serializeObject(sessionAttributes.getAttribute((String)attributeName), output));
            });
        }
    }

    @Override
    public AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes deserialize(DataInput in) {
        AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes sessionAttributes = AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes.create();
        for (int count = this.safeRead(in, DataInput::readInt).intValue(); count > 0; --count) {
            sessionAttributes.setAttribute(this.safeRead(in, DataInput::readUTF), this.safeRead(in, this::deserializeObject));
        }
        return sessionAttributes;
    }
}

