/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.support;

import java.util.Optional;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.support.AbstractSession;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class SessionIdHolder
extends AbstractSession {
    private final String sessionId;

    public static SessionIdHolder create(String sessionId) {
        return new SessionIdHolder(sessionId);
    }

    public SessionIdHolder(String sessionId) {
        this.sessionId = Optional.ofNullable(sessionId).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Session ID [%s] is required", (Object[])new Object[]{sessionId}));
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session that = (Session)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)that.getId());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getId());
        return hashValue;
    }

    public String toString() {
        return this.getId();
    }
}

