/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.session.Session;

public class MongoSession
implements Session {
    private static final char DOT_COVER_CHAR = '\uf607';
    private String id;
    private long createdMillis = System.currentTimeMillis();
    private long accessedMillis;
    private long intervalSeconds;
    private Date expireAt;
    private Map<String, Object> attrs = new HashMap<String, Object>();

    public MongoSession() {
        this(1800L);
    }

    public MongoSession(long maxInactiveIntervalInSeconds) {
        this(UUID.randomUUID().toString(), maxInactiveIntervalInSeconds);
    }

    public MongoSession(String id, long maxInactiveIntervalInSeconds) {
        this.id = id;
        this.intervalSeconds = maxInactiveIntervalInSeconds;
        this.setLastAccessedTime(Instant.ofEpochMilli(this.createdMillis));
    }

    public String getId() {
        return this.id;
    }

    public String changeSessionId() {
        String changedId;
        this.id = changedId = this.generateId();
        return changedId;
    }

    private String generateId() {
        return UUID.randomUUID().toString();
    }

    public <T> T getAttribute(String attributeName) {
        return (T)this.attrs.get(MongoSession.coverDot(attributeName));
    }

    public Set<String> getAttributeNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.attrs.keySet()) {
            result.add(MongoSession.uncoverDot(key));
        }
        return result;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            this.removeAttribute(MongoSession.coverDot(attributeName));
        } else {
            this.attrs.put(MongoSession.coverDot(attributeName), attributeValue);
        }
    }

    public void removeAttribute(String attributeName) {
        this.attrs.remove(MongoSession.coverDot(attributeName));
    }

    public Instant getCreationTime() {
        return Instant.ofEpochMilli(this.createdMillis);
    }

    public void setCreationTime(long created) {
        this.createdMillis = created;
    }

    public void setLastAccessedTime(Instant lastAccessedTime) {
        this.accessedMillis = lastAccessedTime.toEpochMilli();
        this.expireAt = Date.from(lastAccessedTime.plus(Duration.ofSeconds(this.intervalSeconds)));
    }

    public Instant getLastAccessedTime() {
        return Instant.ofEpochMilli(this.accessedMillis);
    }

    public void setMaxInactiveInterval(Duration interval) {
        this.intervalSeconds = interval.getSeconds();
    }

    public Duration getMaxInactiveInterval() {
        return Duration.ofSeconds(this.intervalSeconds);
    }

    public boolean isExpired() {
        return this.intervalSeconds >= 0L && new Date().after(this.expireAt);
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    static String coverDot(String attributeName) {
        return attributeName.replace('.', '\uf607');
    }

    static String uncoverDot(String attributeName) {
        return attributeName.replace('\uf607', '.');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoSession that = (MongoSession)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

