/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOperationsSessionRepository
implements FindByIndexNameSessionRepository<JdbcSession> {
    private static final String DEFAULT_TABLE_NAME = "SPRING_SESSION";
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private static final String CREATE_SESSION_QUERY = "INSERT INTO %TABLE_NAME%(SESSION_ID, CREATION_TIME, LAST_ACCESS_TIME, MAX_INACTIVE_INTERVAL, PRINCIPAL_NAME) VALUES (?, ?, ?, ?, ?)";
    private static final String CREATE_SESSION_ATTRIBUTE_QUERY = "INSERT INTO %TABLE_NAME%_ATTRIBUTES(SESSION_ID, ATTRIBUTE_NAME, ATTRIBUTE_BYTES) VALUES (?, ?, ?)";
    private static final String GET_SESSION_QUERY = "SELECT S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT OUTER JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.SESSION_ID = SA.SESSION_ID WHERE S.SESSION_ID = ?";
    private static final String UPDATE_SESSION_QUERY = "UPDATE %TABLE_NAME% SET LAST_ACCESS_TIME = ?, MAX_INACTIVE_INTERVAL = ?, PRINCIPAL_NAME = ? WHERE SESSION_ID = ?";
    private static final String UPDATE_SESSION_ATTRIBUTE_QUERY = "UPDATE %TABLE_NAME%_ATTRIBUTES SET ATTRIBUTE_BYTES = ? WHERE SESSION_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_ATTRIBUTE_QUERY = "DELETE FROM %TABLE_NAME%_ATTRIBUTES WHERE SESSION_ID = ? AND ATTRIBUTE_NAME = ?";
    private static final String DELETE_SESSION_QUERY = "DELETE FROM %TABLE_NAME% WHERE SESSION_ID = ?";
    private static final String LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT S.SESSION_ID, S.CREATION_TIME, S.LAST_ACCESS_TIME, S.MAX_INACTIVE_INTERVAL, SA.ATTRIBUTE_NAME, SA.ATTRIBUTE_BYTES FROM %TABLE_NAME% S LEFT OUTER JOIN %TABLE_NAME%_ATTRIBUTES SA ON S.SESSION_ID = SA.SESSION_ID WHERE S.PRINCIPAL_NAME = ?";
    private static final String DELETE_SESSIONS_BY_LAST_ACCESS_TIME_QUERY = "DELETE FROM %TABLE_NAME% WHERE LAST_ACCESS_TIME < ?";
    private static final Log logger = LogFactory.getLog(JdbcOperationsSessionRepository.class);
    private static final PrincipalNameResolver PRINCIPAL_NAME_RESOLVER = new PrincipalNameResolver();
    private final JdbcOperations jdbcOperations;
    private final TransactionOperations transactionOperations;
    private final RowMapper<ExpiringSession> mapper = new ExpiringSessionMapper();
    private String tableName = "SPRING_SESSION";
    private Integer defaultMaxInactiveInterval;
    private ConversionService conversionService;
    private LobHandler lobHandler = new DefaultLobHandler();

    public JdbcOperationsSessionRepository(DataSource dataSource, PlatformTransactionManager transactionManager) {
        this((JdbcOperations)JdbcOperationsSessionRepository.createDefaultJdbcTemplate(dataSource), transactionManager);
    }

    public JdbcOperationsSessionRepository(JdbcOperations jdbcOperations, PlatformTransactionManager transactionManager) {
        Assert.notNull((Object)jdbcOperations, (String)"JdbcOperations must not be null");
        this.jdbcOperations = jdbcOperations;
        this.transactionOperations = JdbcOperationsSessionRepository.createTransactionTemplate(transactionManager);
        this.conversionService = JdbcOperationsSessionRepository.createDefaultConversionService();
    }

    public void setTableName(String tableName) {
        Assert.hasText((String)tableName, (String)"Table name must not be empty");
        this.tableName = tableName.trim();
    }

    public void setDefaultMaxInactiveInterval(Integer defaultMaxInactiveInterval) {
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setLobHandler(LobHandler lobHandler) {
        Assert.notNull((Object)lobHandler, (String)"LobHandler must not be null");
        this.lobHandler = lobHandler;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public JdbcSession createSession() {
        JdbcSession session = new JdbcSession();
        if (this.defaultMaxInactiveInterval != null) {
            session.setMaxInactiveIntervalInSeconds(this.defaultMaxInactiveInterval);
        }
        return session;
    }

    @Override
    public void save(final JdbcSession session) {
        if (session.isNew()) {
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.CREATE_SESSION_QUERY), new PreparedStatementSetter(){

                        public void setValues(PreparedStatement ps) throws SQLException {
                            ps.setString(1, session.getId());
                            ps.setLong(2, session.getCreationTime());
                            ps.setLong(3, session.getLastAccessedTime());
                            ps.setInt(4, session.getMaxInactiveIntervalInSeconds());
                            ps.setString(5, session.getPrincipalName());
                        }
                    });
                    final ArrayList<String> attributeNames = new ArrayList<String>(session.getAttributeNames());
                    JdbcOperationsSessionRepository.this.jdbcOperations.batchUpdate(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.CREATE_SESSION_ATTRIBUTE_QUERY), new BatchPreparedStatementSetter(){

                        public void setValues(PreparedStatement ps, int i) throws SQLException {
                            String attributeName = (String)attributeNames.get(i);
                            ps.setString(1, session.getId());
                            ps.setString(2, attributeName);
                            JdbcOperationsSessionRepository.this.serialize(ps, 3, session.getAttribute(attributeName));
                        }

                        public int getBatchSize() {
                            return attributeNames.size();
                        }
                    });
                }
            });
        } else {
            this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    Map<String, Object> delta;
                    if (session.isChanged()) {
                        JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.UPDATE_SESSION_QUERY), new PreparedStatementSetter(){

                            public void setValues(PreparedStatement ps) throws SQLException {
                                ps.setLong(1, session.getLastAccessedTime());
                                ps.setInt(2, session.getMaxInactiveIntervalInSeconds());
                                ps.setString(3, session.getPrincipalName());
                                ps.setString(4, session.getId());
                            }
                        });
                    }
                    if (!(delta = session.getDelta()).isEmpty()) {
                        for (final Map.Entry<String, Object> entry : delta.entrySet()) {
                            if (entry.getValue() == null) {
                                JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.DELETE_SESSION_ATTRIBUTE_QUERY), new PreparedStatementSetter(){

                                    public void setValues(PreparedStatement ps) throws SQLException {
                                        ps.setString(1, session.getId());
                                        ps.setString(2, (String)entry.getKey());
                                    }
                                });
                                continue;
                            }
                            int updatedCount = JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.UPDATE_SESSION_ATTRIBUTE_QUERY), new PreparedStatementSetter(){

                                public void setValues(PreparedStatement ps) throws SQLException {
                                    JdbcOperationsSessionRepository.this.serialize(ps, 1, entry.getValue());
                                    ps.setString(2, session.getId());
                                    ps.setString(3, (String)entry.getKey());
                                }
                            });
                            if (updatedCount != 0) continue;
                            JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.CREATE_SESSION_ATTRIBUTE_QUERY), new PreparedStatementSetter(){

                                public void setValues(PreparedStatement ps) throws SQLException {
                                    ps.setString(1, session.getId());
                                    ps.setString(2, (String)entry.getKey());
                                    JdbcOperationsSessionRepository.this.serialize(ps, 3, entry.getValue());
                                }
                            });
                        }
                    }
                }
            });
        }
        session.clearChangeFlags();
    }

    @Override
    public JdbcSession getSession(final String id) {
        ExpiringSession session = (ExpiringSession)this.transactionOperations.execute((TransactionCallback)new TransactionCallback<ExpiringSession>(){

            public ExpiringSession doInTransaction(TransactionStatus status) {
                List sessions = JdbcOperationsSessionRepository.this.jdbcOperations.query(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                        PreparedStatement ps = con.prepareStatement(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.GET_SESSION_QUERY), 1004, 1007);
                        ps.setString(1, id);
                        return ps;
                    }
                }, JdbcOperationsSessionRepository.this.mapper);
                if (sessions.isEmpty()) {
                    return null;
                }
                return (ExpiringSession)sessions.get(0);
            }
        });
        if (session != null) {
            if (session.isExpired()) {
                this.delete(id);
            } else {
                return new JdbcSession(session);
            }
        }
        return null;
    }

    @Override
    public void delete(final String id) {
        this.transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.DELETE_SESSION_QUERY), new Object[]{id});
            }
        });
    }

    @Override
    public Map<String, JdbcSession> findByIndexNameAndIndexValue(String indexName, final String indexValue) {
        if (!PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Collections.emptyMap();
        }
        List sessions = (List)this.transactionOperations.execute((TransactionCallback)new TransactionCallback<List<ExpiringSession>>(){

            public List<ExpiringSession> doInTransaction(TransactionStatus status) {
                return JdbcOperationsSessionRepository.this.jdbcOperations.query(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                        PreparedStatement ps = con.prepareStatement(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.LIST_SESSIONS_BY_PRINCIPAL_NAME_QUERY), 1004, 1007);
                        ps.setString(1, indexValue);
                        return ps;
                    }
                }, JdbcOperationsSessionRepository.this.mapper);
            }
        });
        HashMap<String, JdbcSession> sessionMap = new HashMap<String, JdbcSession>(sessions.size());
        for (ExpiringSession session : sessions) {
            sessionMap.put(session.getId(), new JdbcSession(session));
        }
        return sessionMap;
    }

    @Scheduled(cron="0 * * * * *")
    public void cleanUpExpiredSessions() {
        long now = System.currentTimeMillis();
        int maxInactiveIntervalSeconds = this.defaultMaxInactiveInterval != null ? this.defaultMaxInactiveInterval : 1800;
        final long sessionsValidFromTime = now - (long)(maxInactiveIntervalSeconds * 1000);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up sessions older than " + new Date(sessionsValidFromTime)));
        }
        int deletedCount = (Integer)this.transactionOperations.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction(TransactionStatus transactionStatus) {
                return JdbcOperationsSessionRepository.this.jdbcOperations.update(JdbcOperationsSessionRepository.this.getQuery(JdbcOperationsSessionRepository.DELETE_SESSIONS_BY_LAST_ACCESS_TIME_QUERY), new Object[]{sessionsValidFromTime});
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaned up " + deletedCount + " expired sessions"));
        }
    }

    private static JdbcTemplate createDefaultJdbcTemplate(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.afterPropertiesSet();
        return jdbcTemplate;
    }

    private static TransactionTemplate createTransactionTemplate(PlatformTransactionManager transactionManager) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.afterPropertiesSet();
        return transactionTemplate;
    }

    private static GenericConversionService createDefaultConversionService() {
        GenericConversionService converter = new GenericConversionService();
        converter.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        converter.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
        return converter;
    }

    protected String getQuery(String base) {
        return StringUtils.replace((String)base, (String)"%TABLE_NAME%", (String)this.tableName);
    }

    private void serialize(PreparedStatement ps, int paramIndex, Object attributeValue) throws SQLException {
        this.lobHandler.getLobCreator().setBlobAsBytes(ps, paramIndex, (byte[])this.conversionService.convert(attributeValue, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class)));
    }

    private Object deserialize(ResultSet rs, String columnName) throws SQLException {
        return this.conversionService.convert((Object)this.lobHandler.getBlobAsBytes(rs, columnName), TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExpiringSessionMapper
    implements RowMapper<ExpiringSession> {
        private ExpiringSessionMapper() {
        }

        public ExpiringSession mapRow(ResultSet rs, int rowNum) throws SQLException {
            MapSession session = new MapSession(rs.getString("SESSION_ID"));
            session.setCreationTime(rs.getLong("CREATION_TIME"));
            session.setLastAccessedTime(rs.getLong("LAST_ACCESS_TIME"));
            session.setMaxInactiveIntervalInSeconds(rs.getInt("MAX_INACTIVE_INTERVAL"));
            String attributeName = rs.getString("ATTRIBUTE_NAME");
            if (attributeName != null) {
                session.setAttribute(attributeName, JdbcOperationsSessionRepository.this.deserialize(rs, "ATTRIBUTE_BYTES"));
                while (rs.next() && session.getId().equals(rs.getString("SESSION_ID"))) {
                    session.setAttribute(rs.getString("ATTRIBUTE_NAME"), JdbcOperationsSessionRepository.this.deserialize(rs, "ATTRIBUTE_BYTES"));
                }
                rs.previous();
            }
            return session;
        }
    }

    static class PrincipalNameResolver {
        private SpelExpressionParser parser = new SpelExpressionParser();

        PrincipalNameResolver() {
        }

        public String resolvePrincipal(Session session) {
            String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
            if (principalName != null) {
                return principalName;
            }
            Object authentication = session.getAttribute(JdbcOperationsSessionRepository.SPRING_SECURITY_CONTEXT);
            if (authentication != null) {
                Expression expression = this.parser.parseExpression("authentication?.name");
                return (String)expression.getValue(authentication, String.class);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class JdbcSession
    implements ExpiringSession {
        private final ExpiringSession delegate;
        private boolean isNew;
        private boolean changed;
        private Map<String, Object> delta = new HashMap<String, Object>();

        JdbcSession() {
            this.delegate = new MapSession();
            this.isNew = true;
        }

        JdbcSession(ExpiringSession delegate) {
            Assert.notNull((Object)"ExpiringSession cannot be null");
            this.delegate = delegate;
        }

        boolean isNew() {
            return this.isNew;
        }

        boolean isChanged() {
            return this.changed;
        }

        Map<String, Object> getDelta() {
            return this.delta;
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.changed = false;
            this.delta.clear();
        }

        String getPrincipalName() {
            return PRINCIPAL_NAME_RESOLVER.resolvePrincipal(this);
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public <T> T getAttribute(String attributeName) {
            return this.delegate.getAttribute(attributeName);
        }

        @Override
        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
            this.delegate.setAttribute(attributeName, attributeValue);
            this.delta.put(attributeName, attributeValue);
            if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(attributeName) || JdbcOperationsSessionRepository.SPRING_SECURITY_CONTEXT.equals(attributeName)) {
                this.changed = true;
            }
        }

        @Override
        public void removeAttribute(String attributeName) {
            this.delegate.removeAttribute(attributeName);
            this.delta.put(attributeName, null);
        }

        @Override
        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        @Override
        public void setLastAccessedTime(long lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.changed = true;
        }

        @Override
        public long getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        @Override
        public void setMaxInactiveIntervalInSeconds(int interval) {
            this.delegate.setMaxInactiveIntervalInSeconds(interval);
            this.changed = true;
        }

        @Override
        public int getMaxInactiveIntervalInSeconds() {
            return this.delegate.getMaxInactiveIntervalInSeconds();
        }

        @Override
        public boolean isExpired() {
            return this.delegate.isExpired();
        }
    }
}

