/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoExpiringSession;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdkMongoSessionConverter
extends AbstractMongoSessionConverter {
    private static final String ID = "_id";
    private static final String CREATION_TIME = "created";
    private static final String LAST_ACCESSED_TIME = "accessed";
    private static final String MAX_INTERVAL = "interval";
    static final String ATTRIBUTES = "attr";
    private static final String PRINCIPAL_FIELD_NAME = "principal";
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;

    public JdkMongoSessionConverter() {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter());
    }

    public JdkMongoSessionConverter(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer) {
        Assert.notNull(serializer, (String)"serializer cannot be null");
        Assert.notNull(deserializer, (String)"deserializer cannot be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    public Query getQueryForIndex(String indexName, Object indexValue) {
        if (FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME.equals(indexName)) {
            return Query.query((CriteriaDefinition)Criteria.where((String)PRINCIPAL_FIELD_NAME).is(indexValue));
        }
        return null;
    }

    @Override
    protected DBObject convert(MongoExpiringSession session) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.put(ID, (Object)session.getId());
        basicDBObject.put(CREATION_TIME, (Object)session.getCreationTime());
        basicDBObject.put(LAST_ACCESSED_TIME, (Object)session.getLastAccessedTime());
        basicDBObject.put(MAX_INTERVAL, (Object)session.getMaxInactiveIntervalInSeconds());
        basicDBObject.put(PRINCIPAL_FIELD_NAME, (Object)this.extractPrincipal(session));
        basicDBObject.put("expireAt", (Object)session.getExpireAt());
        basicDBObject.put(ATTRIBUTES, (Object)this.serializeAttributes(session));
        return basicDBObject;
    }

    @Override
    protected MongoExpiringSession convert(DBObject sessionWrapper) {
        MongoExpiringSession session = new MongoExpiringSession((String)sessionWrapper.get(ID), (Integer)sessionWrapper.get(MAX_INTERVAL));
        session.setCreationTime((Long)sessionWrapper.get(CREATION_TIME));
        session.setLastAccessedTime((Long)sessionWrapper.get(LAST_ACCESSED_TIME));
        session.setExpireAt((Date)sessionWrapper.get("expireAt"));
        this.deserializeAttributes(sessionWrapper, session);
        return session;
    }

    private byte[] serializeAttributes(Session session) {
        HashMap attributes = new HashMap();
        for (String attrName : session.getAttributeNames()) {
            attributes.put(attrName, session.getAttribute(attrName));
        }
        return (byte[])this.serializer.convert(attributes);
    }

    private void deserializeAttributes(DBObject sessionWrapper, Session session) {
        byte[] attributesBytes = (byte[])sessionWrapper.get(ATTRIBUTES);
        Map attributes = (Map)this.deserializer.convert((Object)attributesBytes);
        for (Map.Entry entry : attributes.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }
}

