/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;

@Deprecated
public class SessionMessageListener
implements MessageListener {
    private static final Log logger = LogFactory.getLog(SessionMessageListener.class);
    private final ApplicationEventPublisher eventPublisher;

    public SessionMessageListener(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] messageChannel = message.getChannel();
        byte[] messageBody = message.getBody();
        if (messageChannel == null || messageBody == null) {
            return;
        }
        String channel = new String(messageChannel);
        if (!channel.endsWith(":del") && !channel.endsWith(":expired")) {
            return;
        }
        String body = new String(messageBody);
        if (!body.startsWith("spring:session:sessions:")) {
            return;
        }
        int beginIndex = body.lastIndexOf(":") + 1;
        int endIndex = body.length();
        String sessionId = body.substring(beginIndex, endIndex);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Publishing SessionDestroyedEvent for session " + sessionId));
        }
        if (channel.endsWith(":del")) {
            this.publishEvent(new SessionDeletedEvent((Object)this, sessionId));
        } else {
            this.publishEvent(new SessionExpiredEvent((Object)this, sessionId));
        }
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error((Object)("Error publishing " + event + "."), ex);
        }
    }
}

