/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.io.IOException;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.shell.jline.ExtendedDefaultParser;
import org.springframework.shell.jline.PromptProvider;

@Configuration(proxyBeanMethods=false)
public class JLineShellAutoConfiguration {
    @Bean(destroyMethod="close")
    public Terminal terminal() {
        try {
            return TerminalBuilder.builder().build();
        }
        catch (IOException e) {
            throw new BeanCreationException("Could not create Terminal: " + e.getMessage());
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={PromptProvider.class})
    public PromptProvider promptProvider() {
        return () -> new AttributedString((CharSequence)"shell:>", AttributedStyle.DEFAULT.foreground(3));
    }

    @Bean
    public Parser parser() {
        ExtendedDefaultParser parser = new ExtendedDefaultParser();
        parser.setEofOnUnclosedQuote(true);
        parser.setEofOnEscapedNewLine(true);
        return parser;
    }
}

