/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.shell.boot.SpringShellProperties;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.shell.config.UserConfigPathProvider;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SpringShellProperties.class})
public class LineReaderAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LineReaderAutoConfiguration.class);
    private Terminal terminal;
    private Completer completer;
    private Parser parser;
    private CommandCatalog commandRegistry;
    private History jLineHistory;
    @Value(value="${spring.application.name:spring-shell}.log")
    private String fallbackHistoryFileName;
    private SpringShellProperties springShellProperties;
    private UserConfigPathProvider userConfigPathProvider;

    public LineReaderAutoConfiguration(Terminal terminal, Completer completer, Parser parser, CommandCatalog commandRegistry, History jLineHistory, SpringShellProperties springShellProperties, UserConfigPathProvider userConfigPathProvider) {
        this.terminal = terminal;
        this.completer = completer;
        this.parser = parser;
        this.commandRegistry = commandRegistry;
        this.jLineHistory = jLineHistory;
        this.springShellProperties = springShellProperties;
        this.userConfigPathProvider = userConfigPathProvider;
    }

    @EventListener
    public void onContextClosedEvent(ContextClosedEvent event) throws IOException {
        this.jLineHistory.save();
    }

    @Bean
    public LineReader lineReader() {
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(this.terminal).appName("Spring Shell").completer(this.completer).history(this.jLineHistory).highlighter(new Highlighter(){

            public AttributedString highlight(LineReader reader, String buffer) {
                int l = 0;
                String best = null;
                for (String command : LineReaderAutoConfiguration.this.commandRegistry.getRegistrations().keySet()) {
                    if (!buffer.startsWith(command) || command.length() <= l) continue;
                    l = command.length();
                    best = command;
                }
                if (best != null) {
                    return new AttributedStringBuilder(buffer.length()).append(best, AttributedStyle.BOLD).append((CharSequence)buffer.substring(l)).toAttributedString();
                }
                return new AttributedString((CharSequence)buffer, AttributedStyle.DEFAULT.foreground(1));
            }

            public void setErrorPattern(Pattern errorPattern) {
            }

            public void setErrorIndex(int errorIndex) {
            }
        }).parser(this.parser);
        LineReader lineReader = lineReaderBuilder.build();
        if (this.springShellProperties.getHistory().isEnabled()) {
            Path userConfigPath = this.userConfigPathProvider.provide();
            log.debug("Resolved userConfigPath {}", (Object)userConfigPath);
            String historyFileName = this.springShellProperties.getHistory().getName();
            if (!StringUtils.hasText((String)historyFileName)) {
                historyFileName = this.fallbackHistoryFileName;
            }
            log.debug("Resolved historyFileName {}", (Object)historyFileName);
            String historyPath = userConfigPath.resolve(historyFileName).toAbsolutePath().toString();
            log.debug("Resolved historyPath {}", (Object)historyPath);
            lineReader.setVariable("history-file", (Object)Paths.get(historyPath, new String[0]));
        }
        lineReader.unsetOpt(LineReader.Option.INSERT_TAB);
        this.jLineHistory.attach(lineReader);
        return lineReader;
    }
}

