/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.boot.ExitCodeExceptionMapper;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.shell.command.CommandExecution;
import org.springframework.shell.exit.ExitCodeExceptionProvider;
import org.springframework.shell.exit.ExitCodeMappings;

@AutoConfiguration
public class ExitCodeAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ShellExitCodeExceptionMapper shellExitCodeExceptionMapper() {
        return new ShellExitCodeExceptionMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public ShellExitCodeMappingsExceptionMapper shellExitCodeMappingsExceptionMapper() {
        return new ShellExitCodeMappingsExceptionMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExitCodeExceptionProvider exitCodeExceptionProvider() {
        return (exception, code) -> new ShellExitCodeException((Throwable)exception, (int)code);
    }

    static class ShellExitCodeExceptionMapper
    implements ExitCodeExceptionMapper {
        ShellExitCodeExceptionMapper() {
        }

        public int getExitCode(Throwable exception) {
            if (exception instanceof CommandExecution.CommandParserExceptionsException) {
                return 2;
            }
            if (exception.getCause() instanceof CommandExecution.CommandParserExceptionsException) {
                return 2;
            }
            return 0;
        }
    }

    static class ShellExitCodeMappingsExceptionMapper
    implements ExitCodeExceptionMapper,
    ExitCodeMappings {
        private final List<Function<Throwable, Integer>> functions = new ArrayList<Function<Throwable, Integer>>();

        ShellExitCodeMappingsExceptionMapper() {
        }

        public void reset(List<Function<Throwable, Integer>> functions) {
            this.functions.clear();
            if (functions != null) {
                this.functions.addAll(functions);
            }
        }

        public int getExitCode(Throwable exception) {
            int exitCode = 0;
            for (Function<Throwable, Integer> function : this.functions) {
                Integer code;
                Throwable cause = exception.getCause();
                if (cause == null) {
                    cause = exception;
                }
                if ((code = function.apply(cause)) == null || (code <= 0 || code <= exitCode) && (code >= 0 || code >= exitCode)) continue;
                exitCode = code;
            }
            return exitCode;
        }
    }

    static class ShellExitCodeException
    extends RuntimeException
    implements ExitCodeGenerator {
        private int code;

        ShellExitCodeException(Throwable throwable, int code) {
            super(throwable);
            this.code = code;
        }

        public int getExitCode() {
            return this.code;
        }
    }
}

