/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.standard.completion;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.command.CommandCatalog;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupString;

public abstract class AbstractCompletions {
    private final ResourceLoader resourceLoader;
    private final CommandCatalog commandCatalog;

    public AbstractCompletions(ResourceLoader resourceLoader, CommandCatalog commandCatalog) {
        this.resourceLoader = resourceLoader;
        this.commandCatalog = commandCatalog;
    }

    protected Builder builder() {
        return new DefaultBuilder();
    }

    protected CommandModel generateCommandModel() {
        Collection commandsByName = this.commandCatalog.getRegistrations().values();
        HashMap commands = new HashMap();
        HashSet topCommands = new HashSet();
        commandsByName.stream().forEach(registration -> {
            String key = registration.getCommand();
            String[] splitKeys = key.split(" ");
            String commandKey = "";
            for (int i = 0; i < splitKeys.length; ++i) {
                DefaultCommandModelCommand parent = null;
                String main = splitKeys[i];
                if (i > 0) {
                    parent = (DefaultCommandModelCommand)commands.get(commandKey);
                    commandKey = commandKey + " " + splitKeys[i];
                } else {
                    commandKey = splitKeys[i];
                }
                DefaultCommandModelCommand command = commands.computeIfAbsent(commandKey, fullCommand -> new DefaultCommandModelCommand((String)fullCommand, main));
                List<CommandModelOption> options = registration.getOptions().stream().flatMap(co -> Arrays.stream(co.getLongNames())).map(lo -> CommandModelOption.of("--", lo)).collect(Collectors.toList());
                if (i == splitKeys.length - 1) {
                    command.addOptions(options);
                }
                if (parent != null) {
                    parent.addCommand(command);
                }
                if (i != 0) continue;
                topCommands.add(command);
            }
        });
        return new DefaultCommandModel(new ArrayList<CommandModelCommand>(topCommands));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resourceAsString(Resource resource) {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    class DefaultBuilder
    implements Builder {
        private final MultiValueMap<String, Object> defaultAttributes = new LinkedMultiValueMap();
        private final List<Supplier<String>> operations = new ArrayList<Supplier<String>>();
        private String groupResource;

        DefaultBuilder() {
        }

        @Override
        public Builder attribute(String name, Object value) {
            this.defaultAttributes.add((Object)name, value);
            return this;
        }

        @Override
        public Builder group(String resource) {
            this.groupResource = resource;
            return this;
        }

        @Override
        public Builder appendGroup(String instance) {
            Supplier<String> operation = () -> {
                String template = AbstractCompletions.resourceAsString(AbstractCompletions.this.resourceLoader.getResource(this.groupResource));
                STGroupString group = new STGroupString(template);
                ST st = group.getInstanceOf(instance);
                this.defaultAttributes.entrySet().stream().forEach(entry -> {
                    String key = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    values.stream().forEach(v -> st.add(key, v));
                });
                return st.render();
            };
            this.operations.add(operation);
            return this;
        }

        @Override
        public String build() {
            StringBuilder buf = new StringBuilder();
            this.operations.stream().forEach(operation -> buf.append((String)operation.get()));
            return buf.toString();
        }
    }

    static interface Builder {
        public Builder attribute(String var1, Object var2);

        public Builder group(String var1);

        public Builder appendGroup(String var1);

        public String build();
    }

    static class DefaultCommandModelOption
    implements CommandModelOption {
        private String option;

        public DefaultCommandModelOption(String option) {
            this.option = option;
        }

        @Override
        public String option() {
            return this.option;
        }
    }

    class DefaultCommandModelCommand
    implements CommandModelCommand {
        private String fullCommand;
        private String mainCommand;
        private List<CommandModelCommand> commands = new ArrayList<CommandModelCommand>();
        private List<CommandModelOption> options = new ArrayList<CommandModelOption>();

        DefaultCommandModelCommand(String fullCommand, String mainCommand) {
            this.fullCommand = fullCommand;
            this.mainCommand = mainCommand;
        }

        @Override
        public List<String> getCommandParts() {
            return Arrays.asList(this.fullCommand.split(" "));
        }

        @Override
        public String getLastCommandPart() {
            String[] split = this.fullCommand.split(" ");
            return split[split.length - 1];
        }

        @Override
        public String getMainCommand() {
            return this.mainCommand;
        }

        @Override
        public List<String> getSubCommands() {
            return this.commands.stream().map(c -> c.getMainCommand()).collect(Collectors.toList());
        }

        @Override
        public List<String> getFlags() {
            return this.options.stream().map(o -> o.option()).collect(Collectors.toList());
        }

        @Override
        public List<CommandModelCommand> getCommands() {
            return this.commands;
        }

        @Override
        public List<CommandModelOption> getOptions() {
            return this.options;
        }

        void addOptions(List<CommandModelOption> options) {
            this.options.addAll(options);
        }

        void addCommand(DefaultCommandModelCommand command) {
            this.commands.add(command);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.fullCommand == null ? 0 : this.fullCommand.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultCommandModelCommand other = (DefaultCommandModelCommand)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.fullCommand == null ? other.fullCommand != null : !this.fullCommand.equals(other.fullCommand));
        }

        private AbstractCompletions getEnclosingInstance() {
            return AbstractCompletions.this;
        }
    }

    class DefaultCommandModel
    implements CommandModel {
        private final List<CommandModelCommand> commands;

        public DefaultCommandModel(List<CommandModelCommand> commands) {
            this.commands = commands;
        }

        @Override
        public List<CommandModelCommand> getCommands() {
            return this.commands;
        }

        @Override
        public List<CommandModelCommand> getAllCommands() {
            return this.getCommands().stream().flatMap(c -> this.flatten((CommandModelCommand)c)).collect(Collectors.toList());
        }

        @Override
        public List<String> getRootCommands() {
            return this.getCommands().stream().map(c -> c.getLastCommandPart()).collect(Collectors.toList());
        }

        private Stream<CommandModelCommand> flatten(CommandModelCommand command) {
            return Stream.concat(Stream.of(command), command.getCommands().stream().flatMap(c -> this.flatten((CommandModelCommand)c)));
        }
    }

    static interface CommandModelOption {
        public String option();

        public static CommandModelOption of(String prefix, String name) {
            return new DefaultCommandModelOption(String.format("%s%s", prefix, name));
        }
    }

    static interface CommandModelCommand {
        public List<CommandModelCommand> getCommands();

        public List<CommandModelOption> getOptions();

        public List<String> getFlags();

        public List<String> getSubCommands();

        public List<String> getCommandParts();

        public String getMainCommand();

        public String getLastCommandPart();
    }

    static interface CommandModel {
        public List<CommandModelCommand> getCommands();

        public List<CommandModelCommand> getAllCommands();

        public List<String> getRootCommands();
    }
}

