/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal;

import java.io.IOException;
import org.springframework.shell.test.jediterm.terminal.Terminal;
import org.springframework.shell.test.jediterm.terminal.TerminalDataStream;
import org.springframework.shell.test.jediterm.terminal.emulator.Emulator;

public abstract class DataStreamIteratingEmulator
implements Emulator {
    protected final TerminalDataStream myDataStream;
    protected final Terminal myTerminal;
    private boolean myEof = false;

    public DataStreamIteratingEmulator(TerminalDataStream dataStream, Terminal terminal) {
        this.myDataStream = dataStream;
        this.myTerminal = terminal;
    }

    @Override
    public boolean hasNext() {
        return !this.myEof;
    }

    @Override
    public void resetEof() {
        this.myEof = false;
    }

    @Override
    public void next() throws IOException {
        try {
            char b = this.myDataStream.getChar();
            this.processChar(b, this.myTerminal);
        }
        catch (TerminalDataStream.EOF e) {
            this.myEof = true;
        }
    }

    protected abstract void processChar(char var1, Terminal var2) throws IOException;
}

