/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal;

import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.Objects;
import java.util.WeakHashMap;

public class TextStyle {
    private static final EnumSet<Option> NO_OPTIONS = EnumSet.noneOf(Option.class);
    public static final TextStyle EMPTY = new TextStyle();
    private static final WeakHashMap<TextStyle, WeakReference<TextStyle>> styles = new WeakHashMap();
    private final EnumSet<Option> myOptions;

    public TextStyle() {
        this(NO_OPTIONS);
    }

    public TextStyle(EnumSet<Option> options) {
        this.myOptions = options.clone();
    }

    public static TextStyle getCanonicalStyle(TextStyle currentStyle) {
        TextStyle canonStyle;
        WeakReference<TextStyle> canonRef = styles.get(currentStyle);
        if (canonRef != null && (canonStyle = (TextStyle)canonRef.get()) != null) {
            return canonStyle;
        }
        styles.put(currentStyle, new WeakReference<TextStyle>(currentStyle));
        return currentStyle;
    }

    public TextStyle createEmptyWithColors() {
        return new TextStyle();
    }

    public int getId() {
        return this.hashCode();
    }

    public boolean hasOption(Option option) {
        return this.myOptions.contains((Object)option);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextStyle textStyle = (TextStyle)o;
        return this.myOptions.equals(textStyle.myOptions);
    }

    public int hashCode() {
        return Objects.hash(this.myOptions);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private EnumSet<Option> myOptions;

        public Builder(TextStyle textStyle) {
            this.myOptions = textStyle.myOptions.clone();
        }

        public Builder() {
            this.myOptions = EnumSet.noneOf(Option.class);
        }

        public Builder setOption(Option option, boolean val) {
            option.set(this.myOptions, val);
            return this;
        }

        public TextStyle build() {
            return new TextStyle(this.myOptions);
        }
    }

    public static enum Option {
        BOLD,
        ITALIC,
        BLINK,
        DIM,
        INVERSE,
        UNDERLINED,
        HIDDEN;


        private void set(EnumSet<Option> options, boolean val) {
            if (val) {
                options.add(this);
            } else {
                options.remove((Object)this);
            }
        }
    }
}

