/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.emulator.charset;

import org.springframework.shell.test.jediterm.terminal.emulator.charset.CharacterSet;
import org.springframework.shell.test.jediterm.terminal.emulator.charset.CharacterSets;
import org.springframework.shell.test.jediterm.terminal.emulator.charset.GraphicSet;

public class GraphicSetState {
    private final GraphicSet[] myGraphicSets = new GraphicSet[4];
    private GraphicSet myGL;
    private GraphicSet myGR;
    private GraphicSet myGlOverride;

    public GraphicSetState() {
        for (int i = 0; i < this.myGraphicSets.length; ++i) {
            this.myGraphicSets[i] = new GraphicSet(i);
        }
        this.resetState();
    }

    public void designateGraphicSet(GraphicSet graphicSet, char designator) {
        graphicSet.setDesignation(CharacterSet.valueOf(designator));
    }

    public void designateGraphicSet(int num, CharacterSet characterSet) {
        this.getGraphicSet(num).setDesignation(characterSet);
    }

    public GraphicSet getGL() {
        GraphicSet result = this.myGL;
        if (this.myGlOverride != null) {
            result = this.myGlOverride;
            this.myGlOverride = null;
        }
        return result;
    }

    public GraphicSet getGR() {
        return this.myGR;
    }

    public GraphicSet getGraphicSet(int index) {
        return this.myGraphicSets[index % 4];
    }

    public char map(char ch) {
        return CharacterSets.getChar(ch, this.getGL(), this.getGR());
    }

    public void overrideGL(int index) {
        this.myGlOverride = this.getGraphicSet(index);
    }

    public void resetState() {
        for (int i = 0; i < this.myGraphicSets.length; ++i) {
            this.myGraphicSets[i].setDesignation(CharacterSet.valueOf(i == 1 ? (char)'0' : 'B'));
        }
        this.myGL = this.myGraphicSets[0];
        this.myGR = this.myGraphicSets[1];
        this.myGlOverride = null;
    }

    public void setGL(int index) {
        this.myGL = this.getGraphicSet(index);
    }

    public void setGR(int index) {
        this.myGR = this.getGraphicSet(index);
    }

    public int getGLOverrideIndex() {
        return this.myGlOverride != null ? this.myGlOverride.getIndex() : -1;
    }
}

