/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal.ui;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.shell.test.jediterm.terminal.TerminalDisplay;
import org.springframework.shell.test.jediterm.terminal.TerminalOutputStream;
import org.springframework.shell.test.jediterm.terminal.TerminalStarter;
import org.springframework.shell.test.jediterm.terminal.model.LinesBuffer;
import org.springframework.shell.test.jediterm.terminal.model.StyleState;
import org.springframework.shell.test.jediterm.terminal.model.TerminalLine;
import org.springframework.shell.test.jediterm.terminal.model.TerminalTextBuffer;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalCoordinates;
import org.springframework.shell.test.jediterm.terminal.ui.TerminalPanelListener;

public class TerminalPanel
implements TerminalDisplay {
    public static final double SCROLL_SPEED = 0.05;
    protected int myCharSizeWidth = 0;
    protected int myCharSizeHeight = 0;
    protected int myTermSizeWidth = 80;
    protected int myTermSizeHeight = 24;
    private TerminalStarter myTerminalStarter = null;
    private TerminalPanelListener myTerminalPanelListener;
    private final TerminalTextBuffer myTerminalTextBuffer;
    protected int myClientScrollOrigin;
    private String myWindowTitle = "Terminal";
    private AtomicInteger scrollDy = new AtomicInteger(0);
    private TerminalCoordinates myCoordsAccessor;

    public TerminalPanel(TerminalTextBuffer terminalTextBuffer, StyleState styleState) {
        this.myTerminalTextBuffer = terminalTextBuffer;
        this.myTermSizeWidth = terminalTextBuffer.getWidth();
        this.myTermSizeHeight = terminalTextBuffer.getHeight();
    }

    public TerminalPanelListener getTerminalPanelListener() {
        return this.myTerminalPanelListener;
    }

    public void setCoordAccessor(TerminalCoordinates coordAccessor) {
        this.myCoordsAccessor = coordAccessor;
    }

    public void setTerminalStarter(TerminalStarter terminalStarter) {
        this.myTerminalStarter = terminalStarter;
    }

    public void setTerminalPanelListener(TerminalPanelListener terminalPanelListener) {
        this.myTerminalPanelListener = terminalPanelListener;
    }

    public int getPixelWidth() {
        return this.myCharSizeWidth * this.myTermSizeWidth + this.getInsetX();
    }

    public int getPixelHeight() {
        return this.myCharSizeHeight * this.myTermSizeHeight;
    }

    @Override
    public int getColumnCount() {
        return this.myTermSizeWidth;
    }

    @Override
    public int getRowCount() {
        return this.myTermSizeHeight;
    }

    @Override
    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    protected int getInsetX() {
        return 4;
    }

    @Override
    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        this.scrollDy.addAndGet(dy);
    }

    @Override
    public void beep() {
    }

    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalTextBuffer;
    }

    @Override
    public boolean ambiguousCharsAreDoubleWidth() {
        return false;
    }

    @Override
    public void setBracketedPasteMode(boolean enabled) {
    }

    public LinesBuffer getScrollBuffer() {
        return this.myTerminalTextBuffer.getHistoryBuffer();
    }

    public TerminalOutputStream getTerminalOutputStream() {
        return this.myTerminalStarter;
    }

    @Override
    public void setWindowTitle(String name) {
        this.myWindowTitle = name;
        if (this.myTerminalPanelListener != null) {
            this.myTerminalPanelListener.onTitleChanged(this.myWindowTitle);
        }
    }

    public void clearBuffer() {
        this.clearBuffer(true);
    }

    protected void clearBuffer(boolean keepLastLine) {
        if (!this.myTerminalTextBuffer.isUsingAlternateBuffer()) {
            this.myTerminalTextBuffer.clearHistory();
            if (this.myCoordsAccessor != null) {
                if (keepLastLine) {
                    if (this.myCoordsAccessor.getY() > 0) {
                        TerminalLine lastLine = this.myTerminalTextBuffer.getLine(this.myCoordsAccessor.getY() - 1);
                        this.myTerminalTextBuffer.clearAll();
                        this.myCoordsAccessor.setY(0);
                        this.myTerminalTextBuffer.addLine(lastLine);
                    }
                } else {
                    this.myTerminalTextBuffer.clearAll();
                    this.myCoordsAccessor.setX(0);
                    this.myCoordsAccessor.setY(1);
                }
            }
        }
    }

    public void dispose() {
    }

    public static enum TerminalCursorState {
        SHOWING,
        HIDDEN,
        NO_FOCUS;

    }
}

