/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.commands;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.JLineShellComponent;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.MathUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ScriptCommands
implements CommandMarker {
    protected final Logger logger = HandlerUtils.getLogger(this.getClass());
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private JLineShellComponent shell;

    @CliCommand(value={"script"}, help="Parses the specified resource file and executes its commands")
    public void script(@CliOption(key={"", "file"}, help="The file to locate and execute", mandatory=true) File script, @CliOption(key={"lineNumbers"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display line numbers when executing the script") boolean lineNumbers) {
        Assert.notNull((Object)script, (String)"Script file to parse is required");
        double startedNanoseconds = System.nanoTime();
        InputStream inputStream = this.openScript(script);
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(inputStream));
            int i = 0;
            while ((line = in.readLine()) != null) {
                ++i;
                if (lineNumbers) {
                    this.logger.fine("Line " + i + ": " + line);
                } else {
                    this.logger.fine(line);
                }
                if ("".equals(line.trim())) continue;
                boolean success = this.shell.executeScriptLine(line);
                if (success && (line.trim().startsWith("q") || line.trim().startsWith("ex"))) break;
                if (success) continue;
                throw new IllegalStateException("Script execution aborted");
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream, in);
                double executionDurationInSeconds = ((double)System.nanoTime() - startedNanoseconds) / 1.0E9;
                this.logger.fine("Script required " + MathUtils.round(executionDurationInSeconds, 3) + " seconds to execute");
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream, in);
        double executionDurationInSeconds = ((double)System.nanoTime() - startedNanoseconds) / 1.0E9;
        this.logger.fine("Script required " + MathUtils.round(executionDurationInSeconds, 3) + " seconds to execute");
    }

    private InputStream openScript(File script) {
        try {
            return new BufferedInputStream(new FileInputStream(script));
        }
        catch (FileNotFoundException fnfe) {
            Collection<URL> urls = this.findResources(script.getName());
            Assert.notNull(urls, (String)("Unexpected error looking for '" + script.getName() + "'"));
            Assert.notEmpty(urls, (String)("Script '" + script + "' not found on disk or in classpath"));
            Assert.isTrue((urls.size() == 1 ? 1 : 0) != 0, (String)("More than one '" + script + "' was found in the classpath; unable to continue"));
            try {
                return urls.iterator().next().openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected Collection<URL> findResources(String path) {
        try {
            Resource[] resources = this.applicationContext.getResources(path);
            ArrayList<URL> list = new ArrayList<URL>(resources.length);
            for (Resource resource : resources) {
                list.add(resource.getURL());
            }
            return list;
        }
        catch (IOException ex) {
            this.logger.fine("Cannot find path " + path);
            throw new RuntimeException(ex);
        }
    }
}

