/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public abstract class AopNamespaceUtils {
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "org.springframework.aop.config.internalAutoProxyCreator";
    public static final String ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME = "org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
    private static final List APC_PRIORITY_LIST = new ArrayList();
    static /* synthetic */ Class class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator;
    static /* synthetic */ Class class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator;

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator, parserContext, sourceElement);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        AopNamespaceUtils.registryOrEscalateApcAsRequired(class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJAwareAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator, parserContext, sourceElement);
    }

    public static void registerAtAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Object sourceElement) {
        Class cls = AopNamespaceUtils.getAspectJAutoProxyCreatorClassIfPossible();
        AopNamespaceUtils.registryOrEscalateApcAsRequired(cls, parserContext, sourceElement);
    }

    private static void registryOrEscalateApcAsRequired(Class cls, ParserContext parserContext, Object sourceElement) {
        boolean proxyTargetClass;
        Assert.notNull((Object)parserContext, (String)"ParserContext must not be null");
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            BeanDefinition apcDefinition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (cls.getName().equals(apcDefinition.getBeanClassName())) {
                return;
            }
            int currentPriority = AopNamespaceUtils.findPriorityForClass(apcDefinition.getBeanClassName());
            if (currentPriority < (requiredPriority = AopNamespaceUtils.findPriorityForClass(cls.getName()))) {
                apcDefinition.setBeanClassName(cls.getName());
            }
        } else {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
            beanDefinition.setSource(parserContext.extractSource(sourceElement));
            beanDefinition.setRole(2);
            beanDefinition.getPropertyValues().addPropertyValue("order", (Object)new Integer(Integer.MIN_VALUE));
            registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, (BeanDefinition)beanDefinition);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)beanDefinition, AUTO_PROXY_CREATOR_BEAN_NAME);
            parserContext.registerComponent((ComponentDefinition)componentDefinition);
        }
        if (sourceElement instanceof Element && (proxyTargetClass = Boolean.valueOf(((Element)sourceElement).getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE)).booleanValue())) {
            AopNamespaceUtils.forceAutoProxyCreatorToUseClassProxying(registry);
        }
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            BeanDefinition definition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            definition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.TRUE);
        }
    }

    private static Class getAspectJAutoProxyCreatorClassIfPossible() {
        try {
            return ClassUtils.forName((String)ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to load class [org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator]. Are you running on Java 1.5+? Root cause: " + ex);
        }
    }

    private static final int findPriorityForClass(String className) {
        Assert.notNull((Object)className, (String)"Class name must not be null");
        for (int i = 0; i < APC_PRIORITY_LIST.size(); ++i) {
            String str = (String)APC_PRIORITY_LIST.get(i);
            if (!className.equals(str)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class name [" + className + "] is not a known auto-proxy creator class");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        APC_PRIORITY_LIST.add((class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator")) : class$org$springframework$aop$framework$autoproxy$DefaultAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add((class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator == null ? (class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator = AopNamespaceUtils.class$("org.springframework.aop.aspectj.autoproxy.AspectJAwareAdvisorAutoProxyCreator")) : class$org$springframework$aop$aspectj$autoproxy$AspectJAwareAdvisorAutoProxyCreator).getName());
        APC_PRIORITY_LIST.add(ASPECTJ_AUTO_PROXY_CREATOR_CLASS_NAME);
    }
}

