/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

public abstract class ScopedProxyUtils {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";

    public static BeanDefinitionHolder createScopedProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        RootBeanDefinition scopedProxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
        scopedProxyDefinition.setSource(definition.getSource());
        String targetBeanName = TARGET_NAME_PREFIX + originalBeanName;
        scopedProxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
        } else {
            scopedProxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.FALSE);
        }
        scopedProxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        targetDefinition.setAutowireCandidate(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder((BeanDefinition)scopedProxyDefinition, originalBeanName, definition.getAliases());
    }
}

