/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionReaderUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static AbstractBeanDefinition createBeanDefinition(String className, String parent, ConstructorArgumentValues cargs, MutablePropertyValues pvs, ClassLoader classLoader) throws ClassNotFoundException {
        Class beanClass = null;
        if (className != null && classLoader != null) {
            beanClass = ClassUtils.forName((String)className, (ClassLoader)classLoader);
        }
        if (parent == null) {
            if (beanClass != null) {
                return new RootBeanDefinition(beanClass, cargs, pvs);
            }
            return new RootBeanDefinition(className, cargs, pvs);
        }
        if (beanClass != null) {
            return new ChildBeanDefinition(parent, beanClass, cargs, pvs);
        }
        return new ChildBeanDefinition(parent, className, cargs, pvs);
    }

    public static String generateBeanName(AbstractBeanDefinition beanDefinition, BeanDefinitionRegistry beanFactory, boolean isInnerBean) throws BeanDefinitionStoreException {
        String generatedId = beanDefinition.getBeanClassName();
        if (generatedId == null) {
            if (beanDefinition instanceof ChildBeanDefinition) {
                generatedId = ((ChildBeanDefinition)beanDefinition).getParentName() + "$child";
            } else if (beanDefinition.getFactoryBeanName() != null) {
                generatedId = beanDefinition.getFactoryBeanName() + "$created";
            }
        }
        if (!StringUtils.hasText((String)generatedId)) {
            throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), "", "Unnamed bean definition specifies neither 'class' nor 'parent' nor 'factory-bean' - can't generate bean name");
        }
        String id = generatedId;
        if (isInnerBean) {
            id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ObjectUtils.getIdentityHexString((Object)beanDefinition);
        } else {
            int counter = 0;
            while (beanFactory.containsBeanDefinition(id)) {
                id = generatedId + GENERATED_BEAN_NAME_SEPARATOR + ++counter;
            }
        }
        return id;
    }

    public static void registerBeanDefinition(BeanDefinitionHolder bdHolder, BeanDefinitionRegistry beanFactory) throws BeanDefinitionStoreException {
        beanFactory.registerBeanDefinition(bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        if (bdHolder.getAliases() != null) {
            for (int i = 0; i < bdHolder.getAliases().length; ++i) {
                beanFactory.registerAlias(bdHolder.getBeanName(), bdHolder.getAliases()[i]);
            }
        }
    }
}

