/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;

public class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults));
    static final Set acceptedClassLoaders = Collections.synchronizedSet(new HashSet());
    static final Map classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map propertyDescriptorCache;
    static /* synthetic */ Class class$org$springframework$beans$CachedIntrospectionResults;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassLoader(ClassLoader classLoader) {
        Iterator<Object> it;
        if (classLoader == null) {
            return;
        }
        Object object = classCache;
        synchronized (object) {
            it = classCache.keySet().iterator();
            while (it.hasNext()) {
                Class beanClass = (Class)it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
                it.remove();
            }
        }
        object = acceptedClassLoaders;
        synchronized (object) {
            it = acceptedClassLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader registeredLoader = (ClassLoader)it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
                it.remove();
            }
        }
    }

    static CachedIntrospectionResults forClass(Class beanClass) throws BeansException {
        CachedIntrospectionResults results = null;
        Object value = classCache.get(beanClass);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            results = new CachedIntrospectionResults(beanClass);
            if (CachedIntrospectionResults.isCacheSafe(beanClass) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader())) {
                classCache.put(beanClass, results);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not strongly caching class [" + beanClass.getName() + "] because it is not cache-safe"));
                }
                classCache.put(beanClass, new WeakReference<CachedIntrospectionResults>(results));
            }
        }
        return results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        Object[] acceptedLoaderArray = acceptedClassLoaders.toArray();
        for (int i = 0; i < acceptedLoaderArray.length; ++i) {
            ClassLoader registeredLoader = (ClassLoader)acceptedLoaderArray[i];
            if (!CachedIntrospectionResults.isUnderneathClassLoader(classLoader, registeredLoader)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCacheSafe(Class clazz) {
        ClassLoader target = clazz.getClassLoader();
        if (target == null) {
            return false;
        }
        ClassLoader cur = (class$org$springframework$beans$CachedIntrospectionResults == null ? (class$org$springframework$beans$CachedIntrospectionResults = CachedIntrospectionResults.class$("org.springframework.beans.CachedIntrospectionResults")) : class$org$springframework$beans$CachedIntrospectionResults).getClassLoader();
        if (cur == target) {
            return true;
        }
        while (cur != null) {
            if ((cur = cur.getParent()) != target) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == null) {
            return false;
        }
        if (candidate == parent) {
            return true;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class beanClass) throws BeansException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Getting BeanInfo for class [" + beanClass.getName() + "]"));
            }
            this.beanInfo = Introspector.getBeanInfo(beanClass);
            Class classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Caching PropertyDescriptors for class [" + beanClass.getName() + "]"));
            }
            this.propertyDescriptorCache = new HashMap();
            PropertyDescriptor[] pds = this.beanInfo.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                PropertyDescriptor pd = pds[i];
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : "")));
                }
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Cannot get BeanInfo for object of class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyDescriptorCache.get(propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

