/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.LinkedHashMap;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationsAotContribution;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class BeanRegistrationsAotProcessor
implements BeanFactoryInitializationAotProcessor {
    BeanRegistrationsAotProcessor() {
    }

    @Override
    public BeanRegistrationsAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory = new BeanDefinitionMethodGeneratorFactory(beanFactory);
        LinkedHashMap<String, BeanDefinitionMethodGenerator> registrations = new LinkedHashMap<String, BeanDefinitionMethodGenerator>();
        LinkedMultiValueMap aliases = new LinkedMultiValueMap();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            RegisteredBean registeredBean = RegisteredBean.of(beanFactory, beanName);
            BeanDefinitionMethodGenerator beanDefinitionMethodGenerator = beanDefinitionMethodGeneratorFactory.getBeanDefinitionMethodGenerator(registeredBean);
            if (beanDefinitionMethodGenerator != null) {
                registrations.put(beanName, beanDefinitionMethodGenerator);
            }
            for (String alias : beanFactory.getAliases(beanName)) {
                aliases.add((Object)beanName, (Object)alias);
            }
        }
        if (registrations.isEmpty()) {
            return null;
        }
        return new BeanRegistrationsAotContribution(registrations, (MultiValueMap<String, String>)aliases);
    }
}

