/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.quartz.SchedulerConfigException;
import org.quartz.impl.jdbcjobstore.JobStoreCMT;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.SimpleSemaphore;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.util.Assert;

public class LocalDataSourceJobStore
extends JobStoreCMT {
    public static final String TX_DATA_SOURCE_PREFIX = "springTxDataSource.";
    public static final String NON_TX_DATA_SOURCE_PREFIX = "springNonTxDataSource.";
    private @Nullable DataSource dataSource;
    private @Nullable DataSource nonTransactionalDataSource;

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.dataSource = SchedulerFactoryBean.getConfigTimeDataSource();
        if (this.dataSource == null) {
            throw new SchedulerConfigException("No local DataSource found for configuration - 'dataSource' property must be set on SchedulerFactoryBean");
        }
        this.nonTransactionalDataSource = SchedulerFactoryBean.getConfigTimeNonTransactionalDataSource();
        this.setDataSource(TX_DATA_SOURCE_PREFIX + this.getInstanceName());
        this.setNonManagedTXDataSource(NON_TX_DATA_SOURCE_PREFIX + this.getInstanceName());
        this.setDontSetAutoCommitFalse(true);
        this.initializeConnectionProvider();
        try {
            String productName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getDatabaseProductName);
            productName = JdbcUtils.commonDatabaseName((String)productName);
            if (productName != null && productName.toLowerCase(Locale.ROOT).contains("hsql")) {
                this.setUseDBLocks(false);
                this.setLockHandler((Semaphore)new SimpleSemaphore());
            }
        }
        catch (MetaDataAccessException ex) {
            this.logWarnIfNonZero(1, "Could not detect database type. Assuming locks can be taken.");
        }
        super.initialize(loadHelper, signaler);
    }

    void initializeConnectionProvider() {
        final DataSource dataSourceToUse = this.dataSource;
        Assert.state((dataSourceToUse != null ? 1 : 0) != 0, (String)"DataSource must not be null");
        final DataSource nonTxDataSourceToUse = this.nonTransactionalDataSource != null ? this.nonTransactionalDataSource : dataSourceToUse;
        DBConnectionManager.getInstance().addConnectionProvider(TX_DATA_SOURCE_PREFIX + this.getInstanceName(), new ConnectionProvider(){
            final /* synthetic */ LocalDataSourceJobStore this$0;
            {
                this.this$0 = this$0;
            }

            public Connection getConnection() throws SQLException {
                return DataSourceUtils.doGetConnection((DataSource)dataSourceToUse);
            }

            public void shutdown() {
            }

            public void initialize() {
            }
        });
        DBConnectionManager.getInstance().addConnectionProvider(NON_TX_DATA_SOURCE_PREFIX + this.getInstanceName(), new ConnectionProvider(){
            final /* synthetic */ LocalDataSourceJobStore this$0;
            {
                this.this$0 = this$0;
            }

            public Connection getConnection() throws SQLException {
                return nonTxDataSourceToUse.getConnection();
            }

            public void shutdown() {
            }

            public void initialize() {
            }
        });
    }

    protected void closeConnection(Connection con) {
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.dataSource);
    }
}

