/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import jakarta.activation.FileTypeMap;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ConfigurableMimeFileTypeMap
extends FileTypeMap
implements InitializingBean {
    private Resource mappingLocation = new ClassPathResource("mime.types", ((Object)((Object)this)).getClass());
    private String @Nullable [] mappings;
    private @Nullable FileTypeMap fileTypeMap;

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocation = mappingLocation;
    }

    public void setMappings(String ... mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        this.getFileTypeMap();
    }

    protected final FileTypeMap getFileTypeMap() {
        if (this.fileTypeMap == null) {
            try {
                this.fileTypeMap = this.createFileTypeMap(this.mappingLocation, this.mappings);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not load specified MIME type mapping file: " + String.valueOf(this.mappingLocation), ex);
            }
        }
        return this.fileTypeMap;
    }

    protected FileTypeMap createFileTypeMap(@Nullable Resource mappingLocation, String @Nullable [] mappings) throws IOException {
        MimetypesFileTypeMap fileTypeMap = null;
        if (mappingLocation != null) {
            try (InputStream is = mappingLocation.getInputStream();){
                fileTypeMap = new MimetypesFileTypeMap(is);
            }
        } else {
            fileTypeMap = new MimetypesFileTypeMap();
        }
        if (mappings != null) {
            for (String mapping : mappings) {
                fileTypeMap.addMimeTypes(mapping);
            }
        }
        return fileTypeMap;
    }

    public String getContentType(File file) {
        return this.getFileTypeMap().getContentType(file);
    }

    public String getContentType(String fileName) {
        return this.getFileTypeMap().getContentType(fileName);
    }

    public String getContentType(Path path) {
        return this.getFileTypeMap().getContentType(path.getFileName().toString());
    }
}

