/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.resilience.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Pointcut;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.interceptor.ConcurrencyThrottleInterceptor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.resilience.annotation.ConcurrencyLimit;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class ConcurrencyLimitBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor {
    public ConcurrencyLimitBeanPostProcessor() {
        this.setBeforeExistingAdvisors(true);
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(ConcurrencyLimit.class, true);
        AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, ConcurrencyLimit.class, true);
        this.advisor = new DefaultPointcutAdvisor((Pointcut)new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc), (Advice)new ConcurrencyLimitInterceptor());
    }

    private static class ConcurrencyLimitInterceptor
    implements MethodInterceptor {
        private final Map<Object, ConcurrencyThrottleCache> cachePerInstance = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

        private ConcurrencyLimitInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
            Class<?> targetClass;
            Method method = invocation.getMethod();
            Object target = invocation.getThis();
            Class<?> clazz = targetClass = target != null ? target.getClass() : method.getDeclaringClass();
            if (target == null && invocation instanceof ProxyMethodInvocation) {
                ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
                target = methodInvocation.getProxy();
            }
            Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
            ConcurrencyThrottleCache cache = this.cachePerInstance.computeIfAbsent(target, k -> new ConcurrencyThrottleCache());
            MethodInterceptor interceptor = cache.methodInterceptors.get(method);
            if (interceptor == null) {
                ConcurrencyThrottleCache concurrencyThrottleCache = cache;
                synchronized (concurrencyThrottleCache) {
                    interceptor = cache.methodInterceptors.get(method);
                    if (interceptor == null) {
                        boolean perMethod = false;
                        ConcurrencyLimit limit = (ConcurrencyLimit)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, ConcurrencyLimit.class);
                        if (limit != null) {
                            perMethod = true;
                        } else {
                            interceptor = cache.classInterceptor;
                            if (interceptor == null) {
                                limit = (ConcurrencyLimit)AnnotatedElementUtils.getMergedAnnotation(targetClass, ConcurrencyLimit.class);
                            }
                        }
                        if (interceptor == null) {
                            Assert.state((limit != null ? 1 : 0) != 0, (String)"No @ConcurrencyLimit annotation found");
                            interceptor = new ConcurrencyThrottleInterceptor(limit.value());
                            if (!perMethod) {
                                cache.classInterceptor = interceptor;
                            }
                        }
                        cache.methodInterceptors.put(method, interceptor);
                    }
                }
            }
            return interceptor.invoke(invocation);
        }
    }

    private static class ConcurrencyThrottleCache {
        final Map<Method, MethodInterceptor> methodInterceptors = new ConcurrentHashMap<Method, MethodInterceptor>();
        @Nullable MethodInterceptor classInterceptor;

        private ConcurrencyThrottleCache() {
        }
    }
}

