/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import org.jspecify.annotations.Nullable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;

public abstract class AbstractValueAdaptingCache
implements Cache {
    private final boolean allowNullValues;

    protected AbstractValueAdaptingCache(boolean allowNullValues) {
        this.allowNullValues = allowNullValues;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public @Nullable Cache.ValueWrapper get(Object key) {
        return this.toValueWrapper(this.lookup(key));
    }

    @Override
    public <T> @Nullable T get(Object key, @Nullable Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(key));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + String.valueOf(value));
        }
        return (T)value;
    }

    protected abstract @Nullable Object lookup(Object var1);

    protected @Nullable Object fromStoreValue(@Nullable Object storeValue) {
        if (this.allowNullValues && storeValue == NullValue.INSTANCE) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(@Nullable Object userValue) {
        if (userValue == null) {
            if (this.allowNullValues) {
                return NullValue.INSTANCE;
            }
            throw new IllegalArgumentException("Cache '" + this.getName() + "' is configured to not allow null values but null was provided");
        }
        return userValue;
    }

    protected @Nullable Cache.ValueWrapper toValueWrapper(@Nullable Object storeValue) {
        return storeValue != null ? new SimpleValueWrapper(this.fromStoreValue(storeValue)) : null;
    }
}

