/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcTemplate
implements SimpleJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;

    public SimpleJdbcTemplate(DataSource dataSource) {
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public SimpleJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        this.classicJdbcTemplate = classicJdbcTemplate;
    }

    @Override
    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    @Override
    public int queryForInt(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForInt(sql) : this.getJdbcOperations().queryForInt(sql, args);
    }

    @Override
    public long queryForLong(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForLong(sql) : this.getJdbcOperations().queryForLong(sql, args);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForObject(sql, requiredType) : this.getJdbcOperations().queryForObject(sql, args, requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForObject(sql, rm) : this.getJdbcOperations().queryForObject(sql, args, rm));
    }

    @Override
    public <T> List<T> query(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().query(sql, rm) : this.getJdbcOperations().query(sql, args, rm);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForMap(sql) : this.getJdbcOperations().queryForMap(sql, args);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().queryForList(sql) : this.getJdbcOperations().queryForList(sql, args);
    }

    @Override
    public int update(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty((Object[])args) ? this.getJdbcOperations().update(sql) : this.getJdbcOperations().update(sql, args);
    }
}

