/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};

    public static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull((Object)sql, (String)"SQL must not be null");
        HashSet<String> namedParameters = new HashSet<String>();
        ParsedSql parsedSql = new ParsedSql(sql);
        char[] statement = sql.toCharArray();
        boolean withinQuotes = false;
        int currentQuote = 45;
        int namedParameterCount = 0;
        int unnamedParameterCount = 0;
        int totalParameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            int c = statement[i];
            if (withinQuotes) {
                if (c != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (c == 34 || c == 39) {
                withinQuotes = true;
                currentQuote = c;
                continue;
            }
            if (c == 58 || c == 38) {
                int j;
                for (j = i + 1; j < statement.length && !NamedParameterUtils.isParameterSeparator(statement[j]); ++j) {
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    if (!namedParameters.contains(parameter)) {
                        namedParameters.add(parameter);
                        ++namedParameterCount;
                    }
                    parsedSql.addNamedParameter(parameter, i, j);
                    ++totalParameterCount;
                }
                i = j - 1;
                continue;
            }
            if (c != 63) continue;
            ++unnamedParameterCount;
            ++totalParameterCount;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuffer actualSql = new StringBuffer();
        List paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            int[] indexes = parsedSql.getParameterIndexes(i);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k = 0;
                    while (entryIter.hasNext()) {
                        if (k > 0) {
                            actualSql.append(", ");
                        }
                        ++k;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append("(");
                            for (int m = 0; m < expressionList.length; ++m) {
                                if (m > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append("?");
                            }
                            actualSql.append(")");
                            continue;
                        }
                        actualSql.append("?");
                    }
                } else {
                    actualSql.append("?");
                }
            } else {
                actualSql.append("?");
            }
            lastIndex = endIndex;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource paramSource, List declaredParams) {
        Object[] paramArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new InvalidDataAccessApiUsageException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getOriginalSql() + "]");
        }
        List paramNames = parsedSql.getParameterNames();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            try {
                Object value = paramSource.getValue(paramName);
                SqlParameter param = NamedParameterUtils.findParameter(declaredParams, paramName, i);
                paramArray[i] = param != null ? new SqlParameterValue(param, value) : value;
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException("No value supplied for the SQL parameter '" + paramName + "': " + ex.getMessage());
            }
        }
        return paramArray;
    }

    private static SqlParameter findParameter(List declaredParams, String paramName, int paramIndex) {
        if (declaredParams != null) {
            SqlParameter declaredParam;
            Iterator it = declaredParams.iterator();
            while (it.hasNext()) {
                SqlParameter declaredParam2 = (SqlParameter)it.next();
                if (!paramName.equals(declaredParam2.getName())) continue;
                return declaredParam2;
            }
            if (paramIndex < declaredParams.size() && (declaredParam = (SqlParameter)declaredParams.get(paramIndex)).getName() == null) {
                return declaredParam;
            }
        }
        return null;
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (int i = 0; i < PARAMETER_SEPARATORS.length; ++i) {
            if (c != PARAMETER_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    public static int[] buildSqlTypeArray(ParsedSql parsedSql, SqlParameterSource paramSource) {
        int[] sqlTypes = new int[parsedSql.getTotalParameterCount()];
        List paramNames = parsedSql.getParameterNames();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            sqlTypes[i] = paramSource.getSqlType(paramName);
        }
        return sqlTypes;
    }

    public static String parseSqlStatementIntoString(String sql) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, null);
    }

    public static String substituteNamedParameters(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
    }

    public static Object[] buildValueArray(String sql, Map paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(paramMap), null);
    }
}

