/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import org.jspecify.annotations.Nullable;

public class CallParameterMetaData {
    private final boolean function;
    private final @Nullable String parameterName;
    private final int parameterType;
    private final int sqlType;
    private final @Nullable String typeName;
    private final boolean nullable;

    public CallParameterMetaData(boolean function, @Nullable String columnName, int columnType, int sqlType, @Nullable String typeName, boolean nullable) {
        this.function = function;
        this.parameterName = columnName;
        this.parameterType = columnType;
        this.sqlType = sqlType;
        this.typeName = typeName;
        this.nullable = nullable;
    }

    public boolean isFunction() {
        return this.function;
    }

    public @Nullable String getParameterName() {
        return this.parameterName;
    }

    public int getParameterType() {
        return this.parameterType;
    }

    public boolean isReturnParameter() {
        return this.function ? this.parameterType == 4 : this.parameterType == 5 || this.parameterType == 3;
    }

    public boolean isOutParameter() {
        return this.function ? this.parameterType == 3 : this.parameterType == 4;
    }

    public boolean isInOutParameter() {
        return this.function ? this.parameterType == 2 : this.parameterType == 2;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public @Nullable String getTypeName() {
        return this.typeName;
    }

    public boolean isNullable() {
        return this.nullable;
    }
}

