/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTestUtils {
    private static final Log logger = LogFactory.getLog(JdbcTestUtils.class);
    private static final String DEFAULT_COMMENT_PREFIX = "--";
    private static final char DEFAULT_STATEMENT_SEPARATOR = ';';

    public static int countRowsInTable(JdbcTemplate jdbcTemplate, String tableName) {
        return jdbcTemplate.queryForInt("SELECT COUNT(0) FROM " + tableName);
    }

    public static int countRowsInTableWhere(JdbcTemplate jdbcTemplate, String tableName, String whereClause) {
        String sql = "SELECT COUNT(0) FROM " + tableName;
        if (StringUtils.hasText((String)whereClause)) {
            sql = sql + " WHERE " + whereClause;
        }
        return jdbcTemplate.queryForInt(sql);
    }

    public static int deleteFromTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        int totalRowCount = 0;
        for (String tableName : tableNames) {
            int rowCount = jdbcTemplate.update("DELETE FROM " + tableName);
            totalRowCount += rowCount;
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Deleted " + rowCount + " rows from table " + tableName));
        }
        return totalRowCount;
    }

    public static void dropTables(JdbcTemplate jdbcTemplate, String ... tableNames) {
        for (String tableName : tableNames) {
            jdbcTemplate.execute("DROP TABLE " + tableName);
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Dropped table " + tableName));
        }
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, ResourceLoader resourceLoader, String sqlResourcePath, boolean continueOnError) throws DataAccessException {
        Resource resource = resourceLoader.getResource(sqlResourcePath);
        JdbcTestUtils.executeSqlScript(jdbcTemplate, resource, continueOnError);
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, Resource resource, boolean continueOnError) throws DataAccessException {
        JdbcTestUtils.executeSqlScript(jdbcTemplate, new EncodedResource(resource), continueOnError);
    }

    public static void executeSqlScript(JdbcTemplate jdbcTemplate, EncodedResource resource, boolean continueOnError) throws DataAccessException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing SQL script from " + resource));
        }
        long startTime = System.currentTimeMillis();
        LinkedList<String> statements = new LinkedList<String>();
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(resource.getReader());
            String script = JdbcTestUtils.readScript(reader);
            char delimiter = ';';
            if (!JdbcTestUtils.containsSqlScriptDelimiters(script, delimiter)) {
                delimiter = '\n';
            }
            JdbcTestUtils.splitSqlScript(script, delimiter, statements);
            int lineNumber = 0;
            for (String statement : statements) {
                ++lineNumber;
                try {
                    int rowsAffected = jdbcTemplate.update(statement);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(rowsAffected + " rows affected by SQL: " + statement));
                }
                catch (DataAccessException ex) {
                    if (continueOnError) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("Failed to execute SQL script statement at line " + lineNumber + " of resource " + resource + ": " + statement), (Throwable)ex);
                        continue;
                    }
                    throw ex;
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Executed SQL script from %s in %s ms.", resource, elapsedTime));
            }
        }
        catch (IOException ex) {
            throw new DataAccessResourceFailureException("Failed to open SQL script from " + resource, (Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static String readScript(LineNumberReader lineNumberReader) throws IOException {
        return JdbcTestUtils.readScript(lineNumberReader, DEFAULT_COMMENT_PREFIX);
    }

    public static String readScript(LineNumberReader lineNumberReader, String commentPrefix) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (StringUtils.hasText((String)currentStatement) && commentPrefix != null && !currentStatement.startsWith(commentPrefix)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }

    public static boolean containsSqlScriptDelimiters(String script, char delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (content[i] != delim || inLiteral) continue;
            return true;
        }
        return false;
    }

    public static void splitSqlScript(String script, char delim, List<String> statements) {
        JdbcTestUtils.splitSqlScript(script, "" + delim, DEFAULT_COMMENT_PREFIX, statements);
    }

    private static void splitSqlScript(String script, String delim, String commentPrefix, List<String> statements) {
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        boolean inEscape = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            int c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (c == 39) {
                boolean bl = inLiteral = !inLiteral;
            }
            if (!inLiteral) {
                if (script.startsWith(delim, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += delim.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf("\n", i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (c == 32 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }
}

