/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Method;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatcherAssertionErrors {
    private static final Method describeMismatchMethod = ClassUtils.getMethodIfAvailable(Matcher.class, (String)"describeMismatch", (Class[])new Class[]{Object.class, Description.class});

    private MatcherAssertionErrors() {
    }

    public static <T> void assertThat(T actual, Matcher<T> matcher) {
        MatcherAssertionErrors.assertThat("", actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            description.appendText(reason);
            description.appendText("\nExpected: ");
            description.appendDescriptionOf(matcher);
            if (describeMismatchMethod != null) {
                description.appendText("\n     but: ");
                matcher.describeMismatch(actual, (Description)description);
            } else {
                description.appendText("\n     got: ");
                description.appendValue(actual);
                description.appendText("\n");
            }
            throw new AssertionError((Object)description.toString());
        }
    }
}

