/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewResultMatchers {
    protected ViewResultMatchers() {
    }

    public ResultMatcher name(final Matcher<? super String> matcher) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = result.getModelAndView();
                AssertionErrors.assertTrue("No ModelAndView found", mav != null);
                MatcherAssertionErrors.assertThat("View name", mav.getViewName(), matcher);
            }
        };
    }

    public ResultMatcher name(final String expectedViewName) {
        return new ResultMatcher(){

            public void match(MvcResult result) throws Exception {
                ModelAndView mav = result.getModelAndView();
                AssertionErrors.assertTrue("No ModelAndView found", mav != null);
                AssertionErrors.assertEquals("View name", expectedViewName, mav.getViewName());
            }
        };
    }
}

