/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.http.server.reactive;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.mock.http.server.reactive.MockServerWebExchange;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;

public class MockServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpMethod httpMethod;
    private final MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private final InetSocketAddress remoteAddress;
    private final Flux<DataBuffer> body;

    private MockServerHttpRequest(HttpMethod httpMethod, URI uri, @Nullable String contextPath, HttpHeaders headers, MultiValueMap<String, HttpCookie> cookies, @Nullable InetSocketAddress remoteAddress, Publisher<? extends DataBuffer> body) {
        super(uri, contextPath, headers);
        this.httpMethod = httpMethod;
        this.cookies = cookies;
        this.remoteAddress = remoteAddress;
        this.body = Flux.from(body);
    }

    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    public String getMethodValue() {
        return this.httpMethod.name();
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Flux<DataBuffer> getBody() {
        return this.body;
    }

    protected MultiValueMap<String, HttpCookie> initCookies() {
        return this.cookies;
    }

    public MockServerWebExchange toExchange() {
        return new MockServerWebExchange(this);
    }

    public static BodyBuilder method(HttpMethod method, URI url) {
        return new DefaultBodyBuilder(method, url);
    }

    public static BodyBuilder method(HttpMethod method, String urlTemplate, Object ... vars) {
        URI url = UriComponentsBuilder.fromUriString((String)urlTemplate).buildAndExpand(vars).encode().toUri();
        return new DefaultBodyBuilder(method, url);
    }

    public static BaseBuilder<?> get(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.GET, urlTemplate, uriVars);
    }

    public static BaseBuilder<?> head(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.HEAD, urlTemplate, uriVars);
    }

    public static BodyBuilder post(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.POST, urlTemplate, uriVars);
    }

    public static BodyBuilder put(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.PUT, urlTemplate, uriVars);
    }

    public static BodyBuilder patch(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.PATCH, urlTemplate, uriVars);
    }

    public static BaseBuilder<?> delete(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.DELETE, urlTemplate, uriVars);
    }

    public static BaseBuilder<?> options(String urlTemplate, Object ... uriVars) {
        return MockServerHttpRequest.method(HttpMethod.OPTIONS, urlTemplate, uriVars);
    }

    private static class DefaultBodyBuilder
    implements BodyBuilder {
        private static final DataBufferFactory BUFFER_FACTORY = new DefaultDataBufferFactory();
        private final HttpMethod method;
        private final URI url;
        @Nullable
        private String contextPath;
        private final HttpHeaders headers = new HttpHeaders();
        private final MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();
        @Nullable
        private InetSocketAddress remoteAddress;

        public DefaultBodyBuilder(HttpMethod method, URI url) {
            this.method = method;
            this.url = url;
        }

        @Override
        public BodyBuilder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        @Override
        public BodyBuilder remoteAddress(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        @Override
        public BodyBuilder cookie(HttpCookie ... cookies) {
            Arrays.stream(cookies).forEach(cookie -> this.cookies.add((Object)cookie.getName(), cookie));
            return this;
        }

        @Override
        public BodyBuilder cookies(MultiValueMap<String, HttpCookie> cookies) {
            this.cookies.putAll(cookies);
            return this;
        }

        @Override
        public BodyBuilder header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public BodyBuilder headers(MultiValueMap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        @Override
        public BodyBuilder accept(MediaType ... acceptableMediaTypes) {
            this.headers.setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public BodyBuilder acceptCharset(Charset ... acceptableCharsets) {
            this.headers.setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public BodyBuilder ifModifiedSince(long ifModifiedSince) {
            this.headers.setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public BodyBuilder ifUnmodifiedSince(long ifUnmodifiedSince) {
            this.headers.setIfUnmodifiedSince(ifUnmodifiedSince);
            return this;
        }

        @Override
        public BodyBuilder ifNoneMatch(String ... ifNoneMatches) {
            this.headers.setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public BodyBuilder range(HttpRange ... ranges) {
            this.headers.setRange(Arrays.asList(ranges));
            return this;
        }

        @Override
        public MockServerHttpRequest build() {
            return this.body((Publisher<? extends DataBuffer>)Flux.empty());
        }

        @Override
        public MockServerWebExchange toExchange() {
            return this.build().toExchange();
        }

        @Override
        public MockServerHttpRequest body(String body) {
            return this.body((Publisher<? extends DataBuffer>)Flux.just((Object)BUFFER_FACTORY.wrap(body.getBytes(this.getCharset()))));
        }

        private Charset getCharset() {
            return Optional.ofNullable(this.headers.getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
        }

        @Override
        public MockServerHttpRequest body(Publisher<? extends DataBuffer> body) {
            this.applyCookies();
            return new MockServerHttpRequest(this.method, this.url, this.contextPath, this.headers, this.cookies, this.remoteAddress, body);
        }

        private void applyCookies() {
            this.cookies.values().stream().flatMap(Collection::stream).forEach(cookie -> this.headers.add("Cookie", cookie.toString()));
        }
    }

    public static interface BodyBuilder
    extends BaseBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public MockServerHttpRequest body(Publisher<? extends DataBuffer> var1);

        public MockServerHttpRequest body(String var1);
    }

    public static interface BaseBuilder<B extends BaseBuilder<B>> {
        public B contextPath(String var1);

        public B remoteAddress(InetSocketAddress var1);

        public B cookie(HttpCookie ... var1);

        public B cookies(MultiValueMap<String, HttpCookie> var1);

        public B header(String var1, String ... var2);

        public B headers(MultiValueMap<String, String> var1);

        public B accept(MediaType ... var1);

        public B acceptCharset(Charset ... var1);

        public B ifModifiedSince(long var1);

        public B ifUnmodifiedSince(long var1);

        public B ifNoneMatch(String ... var1);

        public B range(HttpRange ... var1);

        public MockServerHttpRequest build();

        public MockServerWebExchange toExchange();
    }
}

