/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.io.UnsupportedEncodingException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.StringStartsWith;
import org.springframework.lang.Nullable;
import org.springframework.test.util.JsonPathExpectationsHelper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.StringUtils;

public class JsonPathResultMatchers {
    private final JsonPathExpectationsHelper jsonPathHelper;
    @Nullable
    private String prefix;

    protected JsonPathResultMatchers(String expression, Object ... args) {
        this.jsonPathHelper = new JsonPathExpectationsHelper(expression, args);
    }

    public JsonPathResultMatchers prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public <T> ResultMatcher value(Matcher<T> matcher) {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValue(content, matcher);
        };
    }

    public ResultMatcher value(Object expectedValue) {
        return result -> this.jsonPathHelper.assertValue(this.getContent(result), expectedValue);
    }

    public ResultMatcher exists() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.exists(content);
        };
    }

    public ResultMatcher doesNotExist() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.doesNotExist(content);
        };
    }

    public ResultMatcher isEmpty() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsEmpty(content);
        };
    }

    public ResultMatcher isNotEmpty() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsNotEmpty(content);
        };
    }

    public ResultMatcher hasJsonPath() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.hasJsonPath(content);
        };
    }

    public ResultMatcher doesNotHaveJsonPath() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.doesNotHaveJsonPath(content);
        };
    }

    public ResultMatcher isString() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsString(content);
        };
    }

    public ResultMatcher isBoolean() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsBoolean(content);
        };
    }

    public ResultMatcher isNumber() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsNumber(content);
        };
    }

    public ResultMatcher isArray() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsArray(content);
        };
    }

    public ResultMatcher isMap() {
        return result -> {
            String content = this.getContent(result);
            this.jsonPathHelper.assertValueIsMap(content);
        };
    }

    private String getContent(MvcResult result) throws UnsupportedEncodingException {
        String content = result.getResponse().getContentAsString();
        if (StringUtils.hasLength((String)this.prefix)) {
            try {
                String reason = String.format("Expected a JSON payload prefixed with \"%s\" but found: %s", this.prefix, StringUtils.quote((String)content.substring(0, this.prefix.length())));
                MatcherAssert.assertThat((String)reason, (Object)content, (Matcher)StringStartsWith.startsWith((String)this.prefix));
                return content.substring(this.prefix.length());
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new AssertionError("JSON prefix \"" + this.prefix + "\" not found", ex);
            }
        }
        return content;
    }
}

