/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import jakarta.el.ELContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockJspWriter;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

public class MockPageContext
extends PageContext {
    private final ServletContext servletContext;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletConfig servletConfig;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private @Nullable JspWriter out;

    public MockPageContext() {
        this(null, null, null, null);
    }

    public MockPageContext(@Nullable ServletContext servletContext) {
        this(servletContext, null, null, null);
    }

    public MockPageContext(@Nullable ServletContext servletContext, @Nullable HttpServletRequest request) {
        this(servletContext, request, null, null);
    }

    public MockPageContext(@Nullable ServletContext servletContext, @Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        this(servletContext, request, response, null);
    }

    public MockPageContext(@Nullable ServletContext servletContext, @Nullable HttpServletRequest request, @Nullable HttpServletResponse response, @Nullable ServletConfig servletConfig) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.request = request != null ? request : new MockHttpServletRequest(servletContext);
        this.response = response != null ? response : new MockHttpServletResponse();
        this.servletConfig = servletConfig != null ? servletConfig : new MockServletConfig(servletContext);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        throw new UnsupportedOperationException("Use appropriate constructor");
    }

    public void release() {
    }

    public void setAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, @Nullable Object value, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        switch (scope) {
            case 1: {
                this.setAttribute(name, value);
                break;
            }
            case 2: {
                this.request.setAttribute(name, value);
                break;
            }
            case 3: {
                this.request.getSession().setAttribute(name, value);
                break;
            }
            case 4: {
                this.servletContext.setAttribute(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public @Nullable Object getAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        return this.attributes.get(name);
    }

    public @Nullable Object getAttribute(String name, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        return switch (scope) {
            case 1 -> this.getAttribute(name);
            case 2 -> this.request.getAttribute(name);
            case 3 -> {
                HttpSession session = this.request.getSession(false);
                if (session != null) {
                    yield session.getAttribute(name);
                }
                yield null;
            }
            case 4 -> this.servletContext.getAttribute(name);
            default -> throw new IllegalArgumentException("Invalid scope: " + scope);
        };
    }

    public @Nullable Object findAttribute(String name) {
        Object value = this.getAttribute(name);
        if (value == null && (value = this.getAttribute(name, 2)) == null && (value = this.getAttribute(name, 3)) == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public void removeAttribute(String name) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        this.removeAttribute(name, 1);
        this.removeAttribute(name, 2);
        this.removeAttribute(name, 3);
        this.removeAttribute(name, 4);
    }

    public void removeAttribute(String name, int scope) {
        Assert.notNull((Object)name, (String)"Attribute name must not be null");
        switch (scope) {
            case 1: {
                this.attributes.remove(name);
                break;
            }
            case 2: {
                this.request.removeAttribute(name);
                break;
            }
            case 3: {
                this.request.getSession().removeAttribute(name);
                break;
            }
            case 4: {
                this.servletContext.removeAttribute(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(new LinkedHashSet<String>(this.attributes.keySet()));
    }

    public Enumeration<String> getAttributeNamesInScope(int scope) {
        return switch (scope) {
            case 1 -> this.getAttributeNames();
            case 2 -> this.request.getAttributeNames();
            case 3 -> {
                HttpSession session = this.request.getSession(false);
                if (session != null) {
                    yield session.getAttributeNames();
                }
                yield Collections.emptyEnumeration();
            }
            case 4 -> this.servletContext.getAttributeNames();
            default -> throw new IllegalArgumentException("Invalid scope: " + scope);
        };
    }

    public JspWriter getOut() {
        if (this.out == null) {
            this.out = new MockJspWriter(this.response);
        }
        return this.out;
    }

    public @Nullable ELContext getELContext() {
        return null;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public Object getPage() {
        return this;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public @Nullable Exception getException() {
        return null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void forward(String path) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String path) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    public void include(String path, boolean flush) throws ServletException, IOException {
        this.request.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
        if (flush) {
            this.response.flushBuffer();
        }
    }

    public byte[] getContentAsByteArray() {
        HttpServletResponse httpServletResponse = this.response;
        if (httpServletResponse instanceof MockHttpServletResponse) {
            MockHttpServletResponse mockResponse = (MockHttpServletResponse)httpServletResponse;
            return mockResponse.getContentAsByteArray();
        }
        throw new IllegalStateException("MockHttpServletResponse is required");
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        HttpServletResponse httpServletResponse = this.response;
        if (httpServletResponse instanceof MockHttpServletResponse) {
            MockHttpServletResponse mockResponse = (MockHttpServletResponse)httpServletResponse;
            return mockResponse.getContentAsString();
        }
        throw new IllegalStateException("MockHttpServletResponse is required");
    }

    public void handlePageException(Exception ex) throws ServletException, IOException {
        throw new ServletException("Page exception", (Throwable)ex);
    }

    public void handlePageException(Throwable ex) throws ServletException, IOException {
        throw new ServletException("Page exception", ex);
    }
}

