/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryInitializer;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.test.context.DynamicPropertyRegistrar;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.test.context.support.DynamicValuesPropertySource;

public class DynamicPropertyRegistrarBeanInitializer
implements BeanFactoryInitializer<ListableBeanFactory>,
EnvironmentAware {
    private static final Log logger = LogFactory.getLog(DynamicPropertyRegistrarBeanInitializer.class);
    static final String BEAN_NAME = "org.springframework.test.context.support.internalDynamicPropertyRegistrarBeanInitializer";
    private @Nullable ConfigurableEnvironment environment;

    public void setEnvironment(Environment environment) {
        if (!(environment instanceof ConfigurableEnvironment)) {
            throw new IllegalArgumentException("Environment must be a ConfigurableEnvironment");
        }
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment;
        this.environment = configurableEnvironment;
    }

    public void initialize(ListableBeanFactory beanFactory) {
        if (this.environment == null) {
            throw new IllegalStateException("Environment is required");
        }
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, DynamicPropertyRegistrar.class);
        if (beanNames.length > 0) {
            DynamicValuesPropertySource propertySource = DynamicValuesPropertySource.getOrCreate(this.environment);
            DynamicPropertyRegistry registry = propertySource.dynamicPropertyRegistry;
            for (String name : beanNames) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Eagerly initializing DynamicPropertyRegistrar bean '%s'".formatted(name));
                }
                DynamicPropertyRegistrar registrar = (DynamicPropertyRegistrar)beanFactory.getBean(name, DynamicPropertyRegistrar.class);
                registrar.accept(registry);
            }
        }
    }
}

