/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.ResponseCookie;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.support.AbstractCookieAssertions;
import org.springframework.util.MultiValueMap;

public class CookieAssertions
extends AbstractCookieAssertions<ExchangeResult, WebTestClient.ResponseSpec> {
    CookieAssertions(ExchangeResult exchangeResult, WebTestClient.ResponseSpec responseSpec) {
        super(exchangeResult, responseSpec);
    }

    @Override
    protected MultiValueMap<String, ResponseCookie> getResponseCookies() {
        return ((ExchangeResult)this.getExchangeResult()).getResponseCookies();
    }

    @Override
    protected void assertWithDiagnostics(Runnable assertion) {
        ((ExchangeResult)this.getExchangeResult()).assertWithDiagnostics(assertion);
    }

    @Deprecated(since="7.0", forRemoval=true)
    public WebTestClient.ResponseSpec value(String name, Matcher<? super String> matcher) {
        String value = this.getCookie(name).getValue();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name);
            MatcherAssert.assertThat((String)message, (Object)value, (Matcher)matcher);
        });
        return (WebTestClient.ResponseSpec)this.getResponseSpec();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public WebTestClient.ResponseSpec maxAge(String name, Matcher<? super Long> matcher) {
        long maxAge = this.getCookie(name).getMaxAge().getSeconds();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " maxAge";
            MatcherAssert.assertThat((String)message, (Object)maxAge, (Matcher)matcher);
        });
        return (WebTestClient.ResponseSpec)this.getResponseSpec();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public WebTestClient.ResponseSpec path(String name, Matcher<? super String> matcher) {
        String path = this.getCookie(name).getPath();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " path";
            MatcherAssert.assertThat((String)message, (Object)path, (Matcher)matcher);
        });
        return (WebTestClient.ResponseSpec)this.getResponseSpec();
    }

    @Deprecated(since="7.0", forRemoval=true)
    public WebTestClient.ResponseSpec domain(String name, Matcher<? super String> matcher) {
        String domain = this.getCookie(name).getDomain();
        this.assertWithDiagnostics(() -> {
            String message = this.getMessage(name) + " domain";
            MatcherAssert.assertThat((String)message, (Object)domain, (Matcher)matcher);
        });
        return (WebTestClient.ResponseSpec)this.getResponseSpec();
    }
}

