/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

record JsonEncoderDecoder(Encoder<?> encoder, Decoder<?> decoder) {
    private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);

    public JsonConverterDelegate createJsonConverterDelegate() {
        return new CodecsJsonConverterDelegate();
    }

    static @Nullable JsonEncoderDecoder from(Collection<HttpMessageWriter<?>> messageWriters, Collection<HttpMessageReader<?>> messageReaders) {
        Encoder<?> jsonEncoder = JsonEncoderDecoder.findJsonEncoder(messageWriters);
        Decoder<?> jsonDecoder = JsonEncoderDecoder.findJsonDecoder(messageReaders);
        if (jsonEncoder != null && jsonDecoder != null) {
            return new JsonEncoderDecoder(jsonEncoder, jsonDecoder);
        }
        return null;
    }

    private static @Nullable Encoder<?> findJsonEncoder(Collection<HttpMessageWriter<?>> writers) {
        return JsonEncoderDecoder.findJsonEncoder(writers.stream().filter(EncoderHttpMessageWriter.class::isInstance).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()));
    }

    private static @Nullable Encoder<?> findJsonEncoder(Stream<Encoder<?>> stream) {
        return stream.filter(encoder -> encoder.canEncode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElse(null);
    }

    private static @Nullable Decoder<?> findJsonDecoder(Collection<HttpMessageReader<?>> readers) {
        return JsonEncoderDecoder.findJsonDecoder(readers.stream().filter(DecoderHttpMessageReader.class::isInstance).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()));
    }

    private static @Nullable Decoder<?> findJsonDecoder(Stream<Decoder<?>> decoderStream) {
        return decoderStream.filter(decoder -> decoder.canDecode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElse(null);
    }

    private class CodecsJsonConverterDelegate
    implements JsonConverterDelegate {
        private CodecsJsonConverterDelegate() {
        }

        @Override
        public <T> T read(String content, ResolvableType targetType) {
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            DefaultDataBuffer buffer = DefaultDataBufferFactory.sharedInstance.wrap(bytes);
            Object value = JsonEncoderDecoder.this.decoder().decode((DataBuffer)buffer, targetType, (MimeType)MediaType.APPLICATION_JSON, null);
            Assert.state((value != null ? 1 : 0) != 0, () -> "Could not decode JSON content: " + content);
            return (T)value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T map(Object value, ResolvableType targetType) {
            DataBuffer buffer = JsonEncoderDecoder.this.encoder().encodeValue(value, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, targetType, MimeTypeUtils.APPLICATION_JSON, null);
            try {
                T t = this.read(buffer.toString(StandardCharsets.UTF_8), targetType);
                return t;
            }
            finally {
                DataBufferUtils.release((DataBuffer)buffer);
            }
        }
    }
}

