/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.transaction.interceptor.TransactionAttributeSourcePointcut;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    private @Nullable TransactionInterceptor transactionInterceptor;
    private final TransactionAttributeSourcePointcut pointcut = new TransactionAttributeSourcePointcut();

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor) {
        this.setTransactionInterceptor(interceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor) {
        Assert.notNull((Object)interceptor, (String)"TransactionInterceptor must not be null");
        this.transactionInterceptor = interceptor;
        this.pointcut.setTransactionAttributeSource(interceptor.getTransactionAttributeSource());
    }

    public void setClassFilter(ClassFilter classFilter) {
        this.pointcut.setClassFilter(classFilter);
    }

    public Advice getAdvice() {
        Assert.state((this.transactionInterceptor != null ? 1 : 0) != 0, (String)"No TransactionInterceptor set");
        return this.transactionInterceptor;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }
}

