/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public abstract class ExchangeFilterFunctions {
    public static final String BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE = ExchangeFilterFunctions.class.getName() + ".basicAuthenticationCredentials";

    public static ExchangeFilterFunction basicAuthentication(String user, String password) {
        Assert.notNull((Object)user, (String)"'user' must not be null");
        Assert.notNull((Object)password, (String)"'password' must not be null");
        ExchangeFilterFunctions.checkIllegalCharacters(user, password);
        return ExchangeFilterFunctions.basicAuthenticationInternal(request -> Optional.of(new Credentials(user, password)));
    }

    public static ExchangeFilterFunction basicAuthentication() {
        return ExchangeFilterFunctions.basicAuthenticationInternal(request -> request.attribute(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE).map(credentials -> (Credentials)credentials));
    }

    private static ExchangeFilterFunction basicAuthenticationInternal(Function<ClientRequest, Optional<Credentials>> credentialsFunction) {
        return ExchangeFilterFunction.ofRequestProcessor(request -> ((Optional)credentialsFunction.apply((ClientRequest)request)).map(credentials -> Mono.just((Object)ExchangeFilterFunctions.insertAuthorizationHeader(request, credentials))).orElse(Mono.just((Object)request)));
    }

    private static void checkIllegalCharacters(String username, String password) {
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        if (!encoder.canEncode(username) || !encoder.canEncode(password)) {
            throw new IllegalArgumentException("Username or password contains characters that cannot be encoded to ISO-8859-1");
        }
    }

    private static ClientRequest insertAuthorizationHeader(ClientRequest request, Credentials credentials) {
        return ClientRequest.from(request).headers(headers2 -> {
            String credentialsString = credentials.username + ":" + credentials.password;
            byte[] credentialBytes = credentialsString.getBytes(StandardCharsets.ISO_8859_1);
            byte[] encodedBytes = Base64.getEncoder().encode(credentialBytes);
            String encodedCredentials = new String(encodedBytes, StandardCharsets.ISO_8859_1);
            headers2.set("Authorization", "Basic " + encodedCredentials);
        }).build();
    }

    public static ExchangeFilterFunction statusError(Predicate<HttpStatus> statusPredicate, Function<ClientResponse, ? extends Throwable> exceptionFunction) {
        Assert.notNull(statusPredicate, (String)"Predicate must not be null");
        Assert.notNull(exceptionFunction, (String)"Function must not be null");
        return ExchangeFilterFunction.ofResponseProcessor(response -> statusPredicate.test(response.statusCode()) ? Mono.error((Throwable)((Throwable)exceptionFunction.apply((ClientResponse)response))) : Mono.just((Object)response));
    }

    public static final class Credentials {
        private final String username;
        private final String password;

        public Credentials(String username, String password) {
            Assert.notNull((Object)username, (String)"'username' must not be null");
            Assert.notNull((Object)password, (String)"'password' must not be null");
            this.username = username;
            this.password = password;
        }

        public static Consumer<Map<String, Object>> basicAuthenticationCredentials(String user, String password) {
            Credentials credentials = new Credentials(user, password);
            ExchangeFilterFunctions.checkIllegalCharacters(user, password);
            return map -> map.put(BASIC_AUTHENTICATION_CREDENTIALS_ATTRIBUTE, credentials);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Credentials)) {
                return false;
            }
            Credentials otherCred = (Credentials)other;
            return this.username.equals(otherCred.username) && this.password.equals(otherCred.password);
        }

        public int hashCode() {
            return 31 * this.username.hashCode() + this.password.hashCode();
        }
    }
}

