/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.support;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

public class HandshakeWebSocketService
implements WebSocketService,
Lifecycle {
    private static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    private static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private static final Mono<Map<String, Object>> EMPTY_ATTRIBUTES = Mono.just(Collections.emptyMap());
    private static final boolean tomcatPresent;
    private static final boolean jettyPresent;
    private static final boolean undertowPresent;
    private static final boolean reactorNettyPresent;
    protected static final Log logger;
    private final RequestUpgradeStrategy upgradeStrategy;
    @Nullable
    private Predicate<String> sessionAttributePredicate;
    private volatile boolean running = false;

    public HandshakeWebSocketService() {
        this(HandshakeWebSocketService.initUpgradeStrategy());
    }

    public HandshakeWebSocketService(RequestUpgradeStrategy upgradeStrategy) {
        Assert.notNull((Object)upgradeStrategy, (String)"RequestUpgradeStrategy is required");
        this.upgradeStrategy = upgradeStrategy;
    }

    private static RequestUpgradeStrategy initUpgradeStrategy() {
        String className;
        if (tomcatPresent) {
            className = "TomcatRequestUpgradeStrategy";
        } else if (jettyPresent) {
            className = "JettyRequestUpgradeStrategy";
        } else if (undertowPresent) {
            className = "UndertowRequestUpgradeStrategy";
        } else if (reactorNettyPresent) {
            className = "ReactorNettyRequestUpgradeStrategy";
        } else {
            throw new IllegalStateException("No suitable default RequestUpgradeStrategy found");
        }
        try {
            className = "org.springframework.web.reactive.socket.server.upgrade." + className;
            Class clazz = ClassUtils.forName((String)className, (ClassLoader)HandshakeWebSocketService.class.getClassLoader());
            return (RequestUpgradeStrategy)ReflectionUtils.accessibleConstructor((Class)clazz, (Class[])new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to instantiate RequestUpgradeStrategy: " + className, ex);
        }
    }

    public RequestUpgradeStrategy getUpgradeStrategy() {
        return this.upgradeStrategy;
    }

    public void setSessionAttributePredicate(@Nullable Predicate<String> predicate) {
        this.sessionAttributePredicate = predicate;
    }

    @Nullable
    public Predicate<String> getSessionAttributePredicate() {
        return this.sessionAttributePredicate;
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            this.doStart();
        }
    }

    protected void doStart() {
        if (this.getUpgradeStrategy() instanceof Lifecycle) {
            ((Lifecycle)this.getUpgradeStrategy()).start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            this.doStop();
        }
    }

    protected void doStop() {
        if (this.getUpgradeStrategy() instanceof Lifecycle) {
            ((Lifecycle)this.getUpgradeStrategy()).stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Mono<Void> handleRequest(ServerWebExchange exchange, WebSocketHandler handler) {
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method2 = request.getMethod();
        HttpHeaders headers2 = request.getHeaders();
        if (HttpMethod.GET != method2) {
            return Mono.error((Throwable)new MethodNotAllowedException(request.getMethodValue(), Collections.singleton(HttpMethod.GET)));
        }
        if (!"WebSocket".equalsIgnoreCase(headers2.getUpgrade())) {
            return this.handleBadRequest(exchange, "Invalid 'Upgrade' header: " + headers2);
        }
        List connectionValue = headers2.getConnection();
        if (!connectionValue.contains("Upgrade") && !connectionValue.contains("upgrade")) {
            return this.handleBadRequest(exchange, "Invalid 'Connection' header: " + headers2);
        }
        String key = headers2.getFirst(SEC_WEBSOCKET_KEY);
        if (key == null) {
            return this.handleBadRequest(exchange, "Missing \"Sec-WebSocket-Key\" header");
        }
        String protocol = this.selectProtocol(headers2, handler);
        return this.initAttributes(exchange).flatMap(attributes -> this.upgradeStrategy.upgrade(exchange, handler, protocol, () -> this.createHandshakeInfo(exchange, request, protocol, (Map<String, Object>)attributes)));
    }

    private Mono<Void> handleBadRequest(ServerWebExchange exchange, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(exchange.getLogPrefix() + reason));
        }
        return Mono.error((Throwable)new ServerWebInputException(reason));
    }

    @Nullable
    private String selectProtocol(HttpHeaders headers2, WebSocketHandler handler) {
        String protocolHeader = headers2.getFirst(SEC_WEBSOCKET_PROTOCOL);
        if (protocolHeader != null) {
            List<String> supportedProtocols = handler.getSubProtocols();
            for (String protocol : StringUtils.commaDelimitedListToStringArray((String)protocolHeader)) {
                if (!supportedProtocols.contains(protocol)) continue;
                return protocol;
            }
        }
        return null;
    }

    private Mono<Map<String, Object>> initAttributes(ServerWebExchange exchange) {
        if (this.sessionAttributePredicate == null) {
            return EMPTY_ATTRIBUTES;
        }
        return exchange.getSession().map(session -> session.getAttributes().entrySet().stream().filter(entry -> this.sessionAttributePredicate.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private HandshakeInfo createHandshakeInfo(ServerWebExchange exchange, ServerHttpRequest request, @Nullable String protocol, Map<String, Object> attributes) {
        URI uri = request.getURI();
        HttpHeaders headers2 = request.getHeaders();
        Mono principal = exchange.getPrincipal();
        String logPrefix = exchange.getLogPrefix();
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        return new HandshakeInfo(uri, headers2, (Mono<Principal>)principal, protocol, remoteAddress, attributes, logPrefix);
    }

    static {
        ClassLoader classLoader = HandshakeWebSocketService.class.getClassLoader();
        tomcatPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)classLoader);
        jettyPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.websocket.server.WebSocketServerFactory", (ClassLoader)classLoader);
        undertowPresent = ClassUtils.isPresent((String)"io.undertow.websockets.WebSocketProtocolHandshakeHandler", (ClassLoader)classLoader);
        reactorNettyPresent = ClassUtils.isPresent((String)"reactor.netty.http.server.HttpServerResponse", (ClassLoader)classLoader);
        logger = LogFactory.getLog(HandshakeWebSocketService.class);
    }
}

