/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public class FixedContentTypeResolver
implements RequestedContentTypeResolver {
    private final List<MediaType> contentTypes;

    public FixedContentTypeResolver(MediaType mediaType) {
        this(Collections.singletonList(mediaType));
    }

    public FixedContentTypeResolver(List<MediaType> contentTypes) {
        Assert.notNull(contentTypes, (String)"'contentTypes' must not be null");
        this.contentTypes = Collections.unmodifiableList(contentTypes);
    }

    public List<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange) {
        return this.contentTypes;
    }
}

