/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketChannel;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketSession;

public class UndertowWebSocketHandlerAdapter
extends AbstractReceiveListener {
    private final UndertowWebSocketSession session;

    public UndertowWebSocketHandlerAdapter(UndertowWebSocketSession session) {
        Assert.notNull((Object)session, (String)"UndertowWebSocketSession is required");
        this.session = session;
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
        this.session.handleMessage(WebSocketMessage.Type.TEXT, this.toMessage(WebSocketMessage.Type.TEXT, message.getData()));
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
        this.session.handleMessage(WebSocketMessage.Type.BINARY, this.toMessage(WebSocketMessage.Type.BINARY, message.getData().getResource()));
        message.getData().free();
    }

    protected void onFullPongMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
        this.session.handleMessage(WebSocketMessage.Type.PONG, this.toMessage(WebSocketMessage.Type.PONG, message.getData().getResource()));
        message.getData().free();
    }

    protected void onFullCloseMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
        CloseMessage closeMessage = new CloseMessage((ByteBuffer[])message.getData().getResource());
        this.session.handleClose(new CloseStatus(closeMessage.getCode(), closeMessage.getReason()));
        message.getData().free();
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        this.session.handleError(error);
    }

    private <T> WebSocketMessage toMessage(WebSocketMessage.Type type, T message) {
        if (WebSocketMessage.Type.TEXT.equals((Object)type)) {
            byte[] bytes = ((String)message).getBytes(StandardCharsets.UTF_8);
            return new WebSocketMessage(WebSocketMessage.Type.TEXT, this.session.bufferFactory().wrap(bytes));
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)type)) {
            DataBuffer buffer = this.session.bufferFactory().allocateBuffer().write((ByteBuffer[])message);
            return new WebSocketMessage(WebSocketMessage.Type.BINARY, buffer);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)type)) {
            DataBuffer buffer = this.session.bufferFactory().allocateBuffer().write((ByteBuffer[])message);
            return new WebSocketMessage(WebSocketMessage.Type.PONG, buffer);
        }
        throw new IllegalArgumentException("Unexpected message type: " + message);
    }
}

