/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.config.UrlBasedViewResolverRegistration;
import org.springframework.web.reactive.result.view.UrlBasedViewResolver;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfigurer;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerViewResolver;
import org.springframework.web.reactive.result.view.script.ScriptTemplateConfigurer;
import org.springframework.web.reactive.result.view.script.ScriptTemplateViewResolver;

public class ViewResolverRegistry {
    @Nullable
    private final ApplicationContext applicationContext;
    private final List<ViewResolver> viewResolvers = new ArrayList<ViewResolver>(4);
    private final List<View> defaultViews = new ArrayList<View>(4);
    @Nullable
    private Integer order;

    public ViewResolverRegistry(@Nullable ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public UrlBasedViewResolverRegistration freeMarker() {
        if (!this.checkBeanOfType(FreeMarkerConfigurer.class)) {
            throw new BeanInitializationException("In addition to a FreeMarker view resolver there must also be a single FreeMarkerConfig bean in this web application context (or its parent): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.");
        }
        FreeMarkerRegistration registration = new FreeMarkerRegistration();
        UrlBasedViewResolver resolver = registration.getViewResolver();
        if (this.applicationContext != null) {
            resolver.setApplicationContext(this.applicationContext);
        }
        this.viewResolvers.add(resolver);
        return registration;
    }

    public UrlBasedViewResolverRegistration scriptTemplate() {
        if (!this.checkBeanOfType(ScriptTemplateConfigurer.class)) {
            throw new BeanInitializationException("In addition to a script template view resolver there must also be a single ScriptTemplateConfig bean in this web application context (or its parent): ScriptTemplateConfigurer is the usual implementation. This bean may be given any name.");
        }
        ScriptRegistration registration = new ScriptRegistration();
        UrlBasedViewResolver resolver = registration.getViewResolver();
        if (this.applicationContext != null) {
            resolver.setApplicationContext(this.applicationContext);
        }
        this.viewResolvers.add(resolver);
        return registration;
    }

    public void viewResolver(ViewResolver viewResolver) {
        this.viewResolvers.add(viewResolver);
    }

    public void defaultViews(View ... defaultViews) {
        this.defaultViews.addAll(Arrays.asList(defaultViews));
    }

    public boolean hasRegistrations() {
        return !this.viewResolvers.isEmpty();
    }

    public void order(int order) {
        this.order = order;
    }

    private boolean checkBeanOfType(Class<?> beanType) {
        return this.applicationContext == null || !ObjectUtils.isEmpty((Object[])BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, beanType, (boolean)false, (boolean)false));
    }

    protected int getOrder() {
        return this.order != null ? this.order : Integer.MAX_VALUE;
    }

    protected List<ViewResolver> getViewResolvers() {
        return this.viewResolvers;
    }

    protected List<View> getDefaultViews() {
        return this.defaultViews;
    }

    private static class FreeMarkerRegistration
    extends UrlBasedViewResolverRegistration {
        public FreeMarkerRegistration() {
            super(new FreeMarkerViewResolver());
            this.getViewResolver().setSuffix(".ftl");
        }
    }

    private static class ScriptRegistration
    extends UrlBasedViewResolverRegistration {
        public ScriptRegistration() {
            super(new ScriptTemplateViewResolver());
            this.getViewResolver();
        }
    }
}

